/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.automation.modules.rest.ruleif;

import com.atlassian.jira.issue.link.IssueLinkManager;
import com.atlassian.jira.issue.link.IssueLinkType;
import com.atlassian.jira.issue.link.IssueLinkTypeManager;
import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.pocketknife.api.persistence.GlobalPropertyDao;
import com.atlassian.servicedesk.plugins.automation.modules.rest.ruleif.LinkTypeIfConditionResponse;
import com.atlassian.servicedesk.plugins.automation.modules.rest.ruleif.LinkTypeResponse;
import com.google.common.collect.Lists;
import io.atlassian.fugue.Option;
import java.util.ArrayList;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Path(value="/if/linktypes")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class LinkTypeIfConditionRestResource {
    public static final String LINK_TYPE_INWARD = "inward";
    public static final String LINK_TYPE_OUTWARD = "outward";
    public static final String ISSUE_LINK_TYPE_KEY = "servicedesk-automation-special-link-type";
    public static final long NO_DEFAULT_LINK_TYPE = -1L;
    private final IssueLinkTypeManager issueLinkTypeManager;
    private final IssueLinkManager issueLinkManager;
    private final GlobalPermissionManager globalPermissionManager;
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final GlobalPropertyDao globalPropertyDao;

    public LinkTypeIfConditionRestResource(@Nonnull IssueLinkTypeManager issueLinkTypeManager, @Nonnull IssueLinkManager issueLinkManager, @Nonnull GlobalPermissionManager globalPermissionManager, @Nonnull JiraAuthenticationContext jiraAuthenticationContext, GlobalPropertyDao globalPropertyDao) {
        this.issueLinkTypeManager = issueLinkTypeManager;
        this.issueLinkManager = issueLinkManager;
        this.globalPermissionManager = globalPermissionManager;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.globalPropertyDao = globalPropertyDao;
    }

    @GET
    public Response getAllJiraIssueLinkTypesDirections() {
        ArrayList linkTypeResponses = Lists.newArrayList();
        boolean isLinkEnabled = true;
        if (!this.issueLinkManager.isLinkingEnabled()) {
            isLinkEnabled = false;
        } else {
            Collection issueLinkTypes = this.issueLinkTypeManager.getIssueLinkTypes();
            Option issueLinkTypePropertySet = Option.option((Object)this.globalPropertyDao.getLongProperty(ISSUE_LINK_TYPE_KEY));
            Long defaultLinkTypeId = (Long)issueLinkTypePropertySet.getOrElse((Object)-1L);
            for (IssueLinkType issueLinkType : issueLinkTypes) {
                String inward = issueLinkType.getInward();
                String outward = issueLinkType.getOutward();
                boolean isDefaultLinkType = this.isDefaultIssueLinkType(issueLinkType, defaultLinkTypeId);
                if (!inward.equals(outward)) {
                    LinkTypeResponse outwardResponse = new LinkTypeResponse(issueLinkType.getId().toString(), outward, LINK_TYPE_OUTWARD);
                    if (isDefaultLinkType) {
                        linkTypeResponses.add(0, outwardResponse);
                    } else {
                        linkTypeResponses.add(outwardResponse);
                    }
                }
                LinkTypeResponse inwardResponse = new LinkTypeResponse(issueLinkType.getId().toString(), inward, LINK_TYPE_INWARD);
                if (isDefaultLinkType) {
                    linkTypeResponses.add(0, inwardResponse);
                    continue;
                }
                linkTypeResponses.add(inwardResponse);
            }
        }
        ApplicationUser user = this.jiraAuthenticationContext.getLoggedInUser();
        boolean isJiraAdmin = this.isJiraAdministrator(user);
        LinkTypeIfConditionResponse linkTypeIfConditionResponse = new LinkTypeIfConditionResponse(isLinkEnabled, isJiraAdmin, linkTypeResponses);
        return Response.ok((Object)linkTypeIfConditionResponse).build();
    }

    private boolean isDefaultIssueLinkType(@Nonnull IssueLinkType issueLinkType, @Nonnull Long defaultLinkTypeId) {
        return defaultLinkTypeId.equals(issueLinkType.getId());
    }

    private boolean isJiraAdministrator(@Nonnull ApplicationUser user) {
        return this.globalPermissionManager.hasPermission(GlobalPermissionKey.ADMINISTER, user);
    }
}

