/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.automation.modules.issuelinkage;

import com.atlassian.jira.issue.link.IssueLinkType;
import com.atlassian.jira.issue.link.IssueLinkTypeManager;
import com.atlassian.pocketknife.api.persistence.GlobalPropertyDao;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import io.atlassian.fugue.Option;
import java.util.Collection;
import javax.annotation.Nonnull;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class LinkTypeInitializationManager {
    public static final String ISSUE_LINK_TYPE_NAME = "Problem/Incident";
    public static final String OUTWARD = "causes";
    public static final String INWARD = "is caused by";
    public static final String ISSUE_LINK_TYPE_KEY = "servicedesk-automation-special-link-type";
    public static final String ISSUE_LINK_TYPE_STYLE = "servicedesk_automation_default_linktype";
    private static final Logger log = LoggerFactory.getLogger(LinkTypeInitializationManager.class);
    private final IssueLinkTypeManager issueLinkTypeManager;
    private final GlobalPropertyDao globalPropertyDao;

    @Autowired
    public LinkTypeInitializationManager(@Nonnull IssueLinkTypeManager issueLinkTypeManager, @Nonnull GlobalPropertyDao globalPropertyDao) {
        this.issueLinkTypeManager = issueLinkTypeManager;
        this.globalPropertyDao = globalPropertyDao;
    }

    public void createProblemIncidentIssueLinkType() {
        Option issueLinkTypePropertySet = Option.option((Object)this.globalPropertyDao.getLongProperty(ISSUE_LINK_TYPE_KEY));
        if (issueLinkTypePropertySet.isDefined()) {
            return;
        }
        ImmutableSet<IssueLinkType> overlapLinkTypes = this.checkOverlap();
        if (!overlapLinkTypes.isEmpty()) {
            this.setPropertyToPropertySet((IssueLinkType)overlapLinkTypes.iterator().next());
            return;
        }
        this.createSpecialIssueLinkType();
    }

    @VisibleForTesting
    ImmutableSet<IssueLinkType> checkOverlap() {
        Collection linkTypesByOutward;
        Collection linkTypesByInward = this.issueLinkTypeManager.getIssueLinkTypesByInwardDescription(INWARD);
        Collection intersection = CollectionUtils.intersection((Collection)linkTypesByInward, (Collection)(linkTypesByOutward = this.issueLinkTypeManager.getIssueLinkTypesByOutwardDescription(OUTWARD)));
        if (!intersection.isEmpty()) {
            return ImmutableSet.copyOf((Collection)intersection);
        }
        if (!linkTypesByInward.isEmpty()) {
            return ImmutableSet.copyOf((Collection)linkTypesByInward);
        }
        if (!linkTypesByOutward.isEmpty()) {
            return ImmutableSet.copyOf((Collection)linkTypesByOutward);
        }
        return ImmutableSet.of();
    }

    @VisibleForTesting
    void createSpecialIssueLinkType() {
        this.issueLinkTypeManager.createIssueLinkType(ISSUE_LINK_TYPE_NAME, OUTWARD, INWARD, ISSUE_LINK_TYPE_STYLE);
        Collection issueLinkTypesByName = this.issueLinkTypeManager.getIssueLinkTypesByName(ISSUE_LINK_TYPE_NAME);
        Option specialIssueLinkTypeOption = Option.option((Object)Iterables.getFirst((Iterable)issueLinkTypesByName, null));
        if (!specialIssueLinkTypeOption.isDefined()) {
            log.error("Error when creating the issue link type");
        }
        this.setPropertyToPropertySet((IssueLinkType)specialIssueLinkTypeOption.get());
    }

    @VisibleForTesting
    void setPropertyToPropertySet(@Nonnull IssueLinkType specialIssueLinkType) {
        Long specialIssueLinkTypeID = specialIssueLinkType.getId();
        this.globalPropertyDao.setLongProperty(ISSUE_LINK_TYPE_KEY, specialIssueLinkTypeID);
    }
}

