/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.automation.modules.event;

import com.atlassian.fugue.Either;
import com.atlassian.jira.config.StatusManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.history.ChangeItemBean;
import com.atlassian.jira.issue.status.Status;
import com.atlassian.jira.project.Project;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.api.ServiceDeskManager;
import com.atlassian.servicedesk.plugins.automation.modules.event.SDLinkedIssueEventHelper;
import io.atlassian.fugue.Option;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@ParametersAreNonnullByDefault
@Component
public class SDLinkedIssueEventHelperImpl
implements SDLinkedIssueEventHelper {
    private final StatusManager statusManager;
    private final ServiceDeskManager serviceDeskManager;

    @Autowired
    public SDLinkedIssueEventHelperImpl(StatusManager statusManager, ServiceDeskManager serviceDeskManager) {
        this.statusManager = statusManager;
        this.serviceDeskManager = serviceDeskManager;
    }

    @Override
    public boolean isTransitionedEvent(@Nonnull ChangeItemBean changeStatus) {
        return !Objects.equals(changeStatus.getFrom(), changeStatus.getTo());
    }

    @Override
    public Option<Status> getStatus(@Nonnull String id) {
        Status status = this.statusManager.getStatus(id);
        return Option.option((Object)status);
    }

    @Override
    public boolean isServiceDeskIssue(Issue issue) {
        Project projectObject = issue.getProjectObject();
        io.atlassian.fugue.Either serviceDeskForProjectEither = StepsConverters.newerEither((Either)this.serviceDeskManager.getServiceDeskForProject(projectObject));
        return serviceDeskForProjectEither.isRight();
    }
}

