/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.automation.modules.bootstrap;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.sal.api.lifecycle.LifecycleAware;
import com.atlassian.servicedesk.plugins.automation.modules.event.provider.SDLinkedIssueEventProvider;
import com.atlassian.servicedesk.plugins.automation.modules.issuelinkage.LinkTypeInitializationManager;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@ExportAsService
@Component
public class AutomationModulePluginLauncher
implements LifecycleAware {
    private static final Logger log = LoggerFactory.getLogger(AutomationModulePluginLauncher.class);
    private final EventPublisher eventPublisher;
    private final SDLinkedIssueEventProvider SDLinkedIssueEventProvider;
    private final LinkTypeInitializationManager linkTypeInitializationManager;

    @Autowired
    public AutomationModulePluginLauncher(@Nonnull EventPublisher eventPublisher, @Nonnull SDLinkedIssueEventProvider SDLinkedIssueEventProvider2, @Nonnull LinkTypeInitializationManager linkTypeInitializationManager) {
        this.eventPublisher = eventPublisher;
        this.SDLinkedIssueEventProvider = SDLinkedIssueEventProvider2;
        this.linkTypeInitializationManager = linkTypeInitializationManager;
    }

    public void onStart() {
        log.info("Service Desk Automation Modules Plugin is starting...");
        this.tenantlessSetup();
        this.tenantedSetup();
        log.info("Service Desk Automation Modules Plugin is started.");
    }

    private void tenantlessSetup() {
        this.eventPublisher.register((Object)this.SDLinkedIssueEventProvider);
    }

    private void tenantedSetup() {
        log.info("Attempt to create Problem/Incident issue link type...");
        this.linkTypeInitializationManager.createProblemIncidentIssueLinkType();
    }

    public void onStop() {
        log.info("Service Desk Automation Modules Plugin is stopping...");
        this.tenantlessShutdown();
        log.info("Service Desk Automation Modules Plugin is stopped.");
    }

    private void tenantlessShutdown() {
        this.eventPublisher.unregister((Object)this.SDLinkedIssueEventProvider);
    }
}

