/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.automation.modules.blueprint;

import com.atlassian.fugue.Either;
import com.atlassian.fugue.Option;
import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.jql.builder.JqlQueryBuilder;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.commons.error.HttpStatusCode;
import com.atlassian.pocketknife.api.commons.jira.ErrorResultHelper;
import com.atlassian.query.Query;
import com.atlassian.servicedesk.api.ServiceDeskService;
import com.atlassian.servicedesk.api.requesttype.RequestType;
import com.atlassian.servicedesk.api.requesttype.RequestTypeQuery;
import com.atlassian.servicedesk.api.requesttype.RequestTypeService;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.input.BuilderService;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.input.RuleSetInput;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.input.RuleSetInputBuilder;
import com.atlassian.servicedesk.plugins.automation.modules.ruleif.IssueJqlIfConditionHelper;
import com.atlassian.servicedesk.plugins.automation.spi.blueprint.Blueprint;
import com.google.common.base.Optional;
import com.google.common.collect.Iterables;
import java.util.List;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;

public class TriageCustomerRequestBlueprint
implements Blueprint {
    private final BuilderService builderService;
    private final IssueJqlIfConditionHelper issueJqlConditionHelper;
    private final ErrorResultHelper errorResultHelper;
    private final SearchService searchService;
    private final I18nHelper.BeanFactory i18nFactory;
    private final ServiceDeskService serviceDeskService;
    private final RequestTypeService requestTypeService;

    @Autowired
    public TriageCustomerRequestBlueprint(BuilderService builderService, IssueJqlIfConditionHelper issueJqlConditionHelper, ErrorResultHelper errorResultHelper, SearchService searchService, I18nHelper.BeanFactory i18nFactory, ServiceDeskService serviceDeskService, RequestTypeService requestTypeService) {
        this.builderService = builderService;
        this.issueJqlConditionHelper = issueJqlConditionHelper;
        this.errorResultHelper = errorResultHelper;
        this.searchService = searchService;
        this.i18nFactory = i18nFactory;
        this.serviceDeskService = serviceDeskService;
        this.requestTypeService = requestTypeService;
    }

    public Either<AnError, RuleSetInput> generateRuleSetInput(@Nonnull Blueprint.BlueprintParam blueprintParam) {
        ApplicationUser currentUser = blueprintParam.getUser();
        I18nHelper i18nHelper = this.i18nFactory.getInstance(currentUser);
        List projectList = blueprintParam.getProjectContext().getProjects();
        if (projectList.isEmpty()) {
            return this.errorResultHelper.error(HttpStatusCode.BAD_REQUEST, "sd.automation.blueprint.error.missing.project", new Object[0]);
        }
        Project project = (Project)projectList.get(0);
        RuleSetInputBuilder ruleSetBuilder = this.builderService.newRuleSetBuilder().name(i18nHelper.getText("sd.automation.blueprint.triage.request.name")).description(i18nHelper.getText("sd.automation.blueprint.triage.request.description")).metadata().projectContext().project(project).endProjectContext().triggerFromOtherRules(Boolean.valueOf(true)).endMetadata();
        RuleSetInputBuilder.RuleBuilder ruleBuilder = ruleSetBuilder.rule();
        this.buildWhen(ruleBuilder.when());
        RuleSetInputBuilder.IfThenBuilder ifThenBuilder = ruleBuilder.ifThen();
        this.buildIf(ifThenBuilder.ruleIf());
        this.buildThen(currentUser, ifThenBuilder.ruleThen(), project, i18nHelper);
        return Either.right((Object)ruleSetBuilder.build());
    }

    private RuleSetInputBuilder.WhenBuilder buildWhen(RuleSetInputBuilder.WhenBuilder whenBuilder) {
        return whenBuilder.whenHandler().moduleKey("com.atlassian.servicedesk.plugins.automation.servicedesk-automation-modules-plugin:issue-created-automation-rule-when-handler").endWhenHandler();
    }

    private RuleSetInputBuilder.ThenBuilder buildThen(ApplicationUser currentUser, RuleSetInputBuilder.ThenBuilder thenBuilder, Project project, I18nHelper i18nHelper) {
        Option requestTypeOpt = this.getAccountRequestType(currentUser, project, i18nHelper).map(rt -> String.valueOf(rt.getId()));
        return thenBuilder.thenAction().moduleKey("com.atlassian.servicedesk.plugins.automation.servicedesk-automation-modules-plugin:servicedesk-request-type-action").data(this.builderService.newConfigurationDataBuilder().put("requestType", (String)requestTypeOpt.getOrElse((Object)"")).build()).endThenAction();
    }

    private Option<RequestType> getAccountRequestType(ApplicationUser user, Project project, I18nHelper i18nHelper) {
        String accountRequest = i18nHelper.getText("sd.premade.project.servicedesk.requestype.ithelp.name");
        Option serviceDeskOpt = this.serviceDeskService.getServiceDeskForProject(user, project).toOption();
        return serviceDeskOpt.flatMap(serviceDesk -> {
            RequestTypeQuery requestTypeQuery = this.requestTypeService.newQueryBuilder().serviceDesk(Integer.valueOf(serviceDesk.getId())).build();
            return this.requestTypeService.getRequestTypes(user, requestTypeQuery).toOption();
        }).flatMap(pr -> {
            Optional requestTypeOpt = Iterables.tryFind((Iterable)pr.getResults(), requestType -> requestType.getName().equals(accountRequest));
            return Option.option((Object)requestTypeOpt.orNull());
        });
    }

    private RuleSetInputBuilder.IfBuilder buildIf(RuleSetInputBuilder.IfBuilder ifBuilder) {
        String queryAsString = this.getKeywordAndChannelJqlQuery();
        return ifBuilder.ifCondition().moduleKey("com.atlassian.servicedesk.plugins.automation.servicedesk-automation-modules-plugin:jql-if-condition").data(this.issueJqlConditionHelper.createConfigurationData(queryAsString)).endIfCondition();
    }

    private String getKeywordAndChannelJqlQuery() {
        Query priorityQuery = JqlQueryBuilder.newBuilder().where().summary().like("account").and().addCondition("request-channel-type").eq().string("email").buildQuery();
        return this.searchService.getJqlString(priorityQuery);
    }
}

