/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.automation.modules.blueprint;

import com.atlassian.fugue.Either;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.commons.error.HttpStatusCode;
import com.atlassian.pocketknife.api.commons.jira.ErrorResultHelper;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.input.BuilderService;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.input.RuleSetInput;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.input.RuleSetInputBuilder;
import com.atlassian.servicedesk.plugins.automation.modules.common.CommentType;
import com.atlassian.servicedesk.plugins.automation.modules.rulethen.ServiceDeskCommentThenActionHelper;
import com.atlassian.servicedesk.plugins.automation.spi.blueprint.Blueprint;
import java.util.List;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;

public class SetCustomerExpectationsBlueprint
implements Blueprint {
    private final BuilderService builderService;
    private final I18nHelper.BeanFactory i18nFactory;
    private final ErrorResultHelper errorResultHelper;
    private final ServiceDeskCommentThenActionHelper serviceDeskCommentThenActionHelper;

    @Autowired
    public SetCustomerExpectationsBlueprint(BuilderService builderService, I18nHelper.BeanFactory i18nFactory, ErrorResultHelper errorResultHelper, ServiceDeskCommentThenActionHelper serviceDeskCommentThenActionHelper) {
        this.builderService = builderService;
        this.i18nFactory = i18nFactory;
        this.errorResultHelper = errorResultHelper;
        this.serviceDeskCommentThenActionHelper = serviceDeskCommentThenActionHelper;
    }

    public Either<AnError, RuleSetInput> generateRuleSetInput(@Nonnull Blueprint.BlueprintParam blueprintParam) {
        ApplicationUser currentUser = blueprintParam.getUser();
        I18nHelper i18nHelper = this.i18nFactory.getInstance(currentUser);
        List projectList = blueprintParam.getProjectContext().getProjects();
        if (projectList.isEmpty()) {
            return this.errorResultHelper.error(HttpStatusCode.BAD_REQUEST, "sd.automation.blueprint.error.missing.project", new Object[0]);
        }
        Project project = (Project)projectList.get(0);
        RuleSetInputBuilder ruleSetBuilder = this.builderService.newRuleSetBuilder().name(i18nHelper.getText("sd.automation.blueprint.customer.expectations.name")).description(i18nHelper.getText("sd.automation.blueprint.customer.expectations.description")).metadata().projectContext().project(project).endProjectContext().triggerFromOtherRules(Boolean.valueOf(true)).endMetadata();
        RuleSetInputBuilder.RuleBuilder ruleBuilder = ruleSetBuilder.rule();
        this.buildWhen(ruleBuilder.when());
        RuleSetInputBuilder.IfThenBuilder ifThenBuilder = ruleBuilder.ifThen();
        this.buildIf(ifThenBuilder.ruleIf());
        this.buildThen(currentUser, ifThenBuilder.ruleThen());
        return Either.right((Object)ruleSetBuilder.build());
    }

    private RuleSetInputBuilder.WhenBuilder buildWhen(RuleSetInputBuilder.WhenBuilder whenBuilder) {
        return whenBuilder.whenHandler().moduleKey("com.atlassian.servicedesk.plugins.automation.servicedesk-automation-modules-plugin:issue-created-automation-rule-when-handler").endWhenHandler();
    }

    private RuleSetInputBuilder.IfBuilder buildIf(RuleSetInputBuilder.IfBuilder ifBuilder) {
        return ifBuilder;
    }

    private RuleSetInputBuilder.ThenBuilder buildThen(ApplicationUser currentUser, RuleSetInputBuilder.ThenBuilder thenBuilder) {
        return thenBuilder.thenAction().moduleKey("com.atlassian.servicedesk.plugins.automation.servicedesk-automation-modules-plugin:servicedesk-comment-action").data(this.serviceDeskCommentThenActionHelper.createConfigurationData("", CommentType.Public)).endThenAction();
    }
}

