/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.automation.modules.blueprint;

import com.atlassian.fugue.Either;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.commons.error.HttpStatusCode;
import com.atlassian.pocketknife.api.commons.jira.ErrorResultHelper;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.input.BuilderService;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.input.RuleSetInput;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.input.RuleSetInputBuilder;
import com.atlassian.servicedesk.plugins.automation.spi.blueprint.Blueprint;
import java.util.List;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;

public class BlankBlueprint
implements Blueprint {
    private final BuilderService builderService;
    private final ErrorResultHelper errorResultHelper;
    private final I18nHelper.BeanFactory i18nFactory;

    @Autowired
    public BlankBlueprint(BuilderService builderService, ErrorResultHelper errorResultHelper, I18nHelper.BeanFactory i18nFactory) {
        this.builderService = builderService;
        this.errorResultHelper = errorResultHelper;
        this.i18nFactory = i18nFactory;
    }

    public Either<AnError, RuleSetInput> generateRuleSetInput(@Nonnull Blueprint.BlueprintParam blueprintParam) {
        ApplicationUser currentUser = blueprintParam.getUser();
        I18nHelper i18nHelper = this.i18nFactory.getInstance(currentUser);
        List projectList = blueprintParam.getProjectContext().getProjects();
        if (projectList.isEmpty()) {
            return this.errorResultHelper.error(HttpStatusCode.BAD_REQUEST, "sd.automation.blueprint.error.missing.project", new Object[0]);
        }
        Project project = (Project)projectList.get(0);
        RuleSetInputBuilder ruleSetBuilder = this.builderService.newRuleSetBuilder().name(i18nHelper.getText("sd.automation.blueprint.blank.name")).description(i18nHelper.getText("sd.automation.blueprint.blank.description")).metadata().projectContext().project(project).endProjectContext().triggerFromOtherRules(Boolean.valueOf(true)).endMetadata().rule().when().endWhen().ifThen().ruleIf().endIf().ruleThen().endThen().endIfThen().endRule();
        return Either.right((Object)ruleSetBuilder.build());
    }
}

