/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.automation.modules.blueprint;

import com.atlassian.fugue.Either;
import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.config.PriorityManager;
import com.atlassian.jira.issue.priority.Priority;
import com.atlassian.jira.jql.builder.JqlQueryBuilder;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.commons.error.HttpStatusCode;
import com.atlassian.pocketknife.api.commons.jira.ErrorResultHelper;
import com.atlassian.query.Query;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.input.BuilderService;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.input.RuleSetInput;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.input.RuleSetInputBuilder;
import com.atlassian.servicedesk.plugins.automation.modules.ConfigurationDataJsonHelper;
import com.atlassian.servicedesk.plugins.automation.modules.ruleif.IssueJqlIfConditionHelper;
import com.atlassian.servicedesk.plugins.automation.spi.blueprint.Blueprint;
import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.springframework.beans.factory.annotation.Autowired;

public class BeAwareOfUrgentIssuesBlueprint
implements Blueprint {
    private final BuilderService builderService;
    private final IssueJqlIfConditionHelper issueJqlConditionHelper;
    private final PriorityManager priorityManager;
    private final ErrorResultHelper errorResultHelper;
    private final ConfigurationDataJsonHelper configurationDataJsonHelper;
    private final SearchService searchService;
    private final I18nHelper.BeanFactory i18nFactory;

    @Autowired
    public BeAwareOfUrgentIssuesBlueprint(BuilderService builderService, IssueJqlIfConditionHelper issueJqlConditionHelper, PriorityManager priorityManager, ErrorResultHelper errorResultHelper, ConfigurationDataJsonHelper configurationDataJsonHelper, SearchService searchService, I18nHelper.BeanFactory i18nFactory) {
        this.builderService = builderService;
        this.issueJqlConditionHelper = issueJqlConditionHelper;
        this.priorityManager = priorityManager;
        this.errorResultHelper = errorResultHelper;
        this.configurationDataJsonHelper = configurationDataJsonHelper;
        this.searchService = searchService;
        this.i18nFactory = i18nFactory;
    }

    public Either<AnError, RuleSetInput> generateRuleSetInput(@Nonnull Blueprint.BlueprintParam blueprintParam) {
        ApplicationUser currentUser = blueprintParam.getUser();
        I18nHelper i18nHelper = this.i18nFactory.getInstance(currentUser);
        List projectList = blueprintParam.getProjectContext().getProjects();
        if (projectList.isEmpty()) {
            return this.errorResultHelper.error(HttpStatusCode.BAD_REQUEST, "sd.automation.blueprint.error.missing.project", new Object[0]);
        }
        Project project = (Project)projectList.get(0);
        RuleSetInputBuilder ruleSetBuilder = this.builderService.newRuleSetBuilder().name(i18nHelper.getText("sd.automation.blueprint.urgent.issues.name")).description(i18nHelper.getText("sd.automation.blueprint.urgent.issues.description")).metadata().projectContext().project(project).endProjectContext().triggerFromOtherRules(Boolean.valueOf(true)).endMetadata();
        RuleSetInputBuilder.RuleBuilder ruleBuilder = ruleSetBuilder.rule();
        this.buildWhen(ruleBuilder.when());
        RuleSetInputBuilder.IfThenBuilder ifThenBuilder = ruleBuilder.ifThen();
        this.buildIf(ifThenBuilder.ruleIf());
        this.buildThen(currentUser, ifThenBuilder.ruleThen());
        return Either.right((Object)ruleSetBuilder.build());
    }

    private RuleSetInputBuilder.WhenBuilder buildWhen(RuleSetInputBuilder.WhenBuilder whenBuilder) {
        return whenBuilder.whenHandler().moduleKey("com.atlassian.servicedesk.plugins.automation.servicedesk-automation-modules-plugin:issue-created-automation-rule-when-handler").endWhenHandler();
    }

    private RuleSetInputBuilder.ThenBuilder buildThen(ApplicationUser currentUser, RuleSetInputBuilder.ThenBuilder thenBuilder) {
        String currentUserJsonArray = this.getUsersAsJsonArray(currentUser);
        return thenBuilder.thenAction().moduleKey("com.atlassian.servicedesk.plugins.automation.servicedesk-automation-modules-plugin:alert-user-action").data(this.builderService.newConfigurationDataBuilder().put("userKeys", currentUserJsonArray).build()).endThenAction();
    }

    private RuleSetInputBuilder.IfBuilder buildIf(RuleSetInputBuilder.IfBuilder ifBuilder) {
        List<String> priorityNamesList = this.getTopPriorityNamesList(2);
        if (priorityNamesList.isEmpty()) {
            return ifBuilder;
        }
        String priorityQueryAsString = this.getPriorityJqlQuery(priorityNamesList);
        return ifBuilder.ifCondition().moduleKey("com.atlassian.servicedesk.plugins.automation.servicedesk-automation-modules-plugin:jql-if-condition").data(this.issueJqlConditionHelper.createConfigurationData(priorityQueryAsString)).endIfCondition();
    }

    private String getUsersAsJsonArray(ApplicationUser user) {
        return this.configurationDataJsonHelper.convertListToJson(Lists.newArrayList((Object[])new String[]{user.getKey()}));
    }

    private String getPriorityJqlQuery(List<String> priorityNamesList) {
        Query priorityQuery = JqlQueryBuilder.newBuilder().where().priority().in((String[])Iterables.toArray(priorityNamesList, String.class)).buildQuery();
        return this.searchService.getJqlString(priorityQuery);
    }

    private List<String> getTopPriorityNamesList(int numberOfPriorities) {
        List priorities = this.priorityManager.getPriorities();
        ArrayList topPriorities = Lists.newArrayList((Iterable)Iterables.limit((Iterable)priorities, (int)numberOfPriorities));
        return Lists.transform((List)topPriorities, (Function)new Function<Priority, String>(){

            @Nullable
            public String apply(Priority input) {
                return input.getName();
            }
        });
    }
}

