/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.automation.modules;

import com.atlassian.jira.util.json.JSONArray;
import com.atlassian.jira.util.json.JSONException;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.commons.error.ErrorMessage;
import com.atlassian.pocketknife.api.commons.error.HttpStatusCode;
import com.google.common.collect.Lists;
import io.atlassian.fugue.Either;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.springframework.stereotype.Component;

@Component
public class ConfigurationDataJsonHelper {
    public Either<AnError, List<String>> convertJsonToStringList(String json) {
        try {
            JSONArray jsonArray = new JSONArray(json);
            ArrayList stringList = Lists.newArrayList();
            for (int i = 0; i < jsonArray.length(); ++i) {
                String stringValue = jsonArray.getString(i);
                stringList.add(stringValue);
            }
            return Either.right((Object)stringList);
        }
        catch (JSONException exception) {
            ErrorMessage errorMessage = ErrorMessage.builder().message(exception.getMessage()).build();
            return Either.left((Object)new AnError(errorMessage, HttpStatusCode.BAD_REQUEST));
        }
    }

    public String convertListToJson(Collection<? extends String> array) {
        JSONArray jsonArray = new JSONArray(array);
        return jsonArray.toString();
    }
}

