/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.approvals.internal.workflow.transitions;

import com.atlassian.jira.bc.issue.IssueService;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueInputParameters;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.workflow.TransitionOptions;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.servicedesk.plugins.approvals.internal.util.ApprovalError;
import com.atlassian.servicedesk.plugins.approvals.internal.workflow.transitions.TransitionExecutorService;
import io.atlassian.fugue.Either;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TransitionExecutorServiceImpl
implements TransitionExecutorService {
    private final Logger logger = LoggerFactory.getLogger(TransitionExecutorServiceImpl.class);
    private final IssueService issueService;
    private final ApprovalError approvalError;

    @Autowired
    public TransitionExecutorServiceImpl(@Nonnull IssueService issueService, @Nonnull ApprovalError approvalError) {
        this.issueService = issueService;
        this.approvalError = approvalError;
    }

    @Override
    public Either<AnError, Boolean> executeTransition(Issue issue, int transitionId, ApplicationUser user) {
        IssueService.TransitionValidationResult transitionValidationResult = this.validateTransition(issue, transitionId, user);
        if (!transitionValidationResult.isValid()) {
            return Either.left((Object)this.approvalError.UNABLE_TO_PERFORM_TRANSITION());
        }
        IssueService.IssueResult result = this.issueService.transition(user, transitionValidationResult);
        if (!result.isValid()) {
            return Either.left((Object)this.approvalError.UNABLE_TO_PERFORM_TRANSITION());
        }
        return Either.right((Object)true);
    }

    private IssueService.TransitionValidationResult validateTransition(Issue issue, int transitionId, ApplicationUser user) {
        TransitionOptions options = new TransitionOptions.Builder().setAutomaticTransition().skipConditions().skipPermissions().skipValidators().build();
        IssueInputParameters issueInputParameters = this.issueService.newIssueInputParameters();
        IssueService.TransitionValidationResult validationResult = this.issueService.validateTransition(user, issue.getId(), transitionId, issueInputParameters, options);
        return validationResult;
    }
}

