/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.approvals.internal.workflow;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.servicedesk.api.approval.Approval;
import com.atlassian.servicedesk.api.approval.ApprovalDecisionType;
import com.atlassian.servicedesk.internal.api.approval.InternalApprovalService;
import com.atlassian.servicedesk.plugins.approvals.internal.util.ApprovalError;
import com.atlassian.servicedesk.plugins.approvals.internal.workflow.WorkflowApprovalService;
import com.atlassian.servicedesk.plugins.approvals.internal.workflow.configuration.WorkflowApprovalConfiguration;
import com.atlassian.servicedesk.plugins.approvals.internal.workflow.configuration.WorkflowApprovalConfigurationManager;
import com.atlassian.servicedesk.plugins.approvals.internal.workflow.transitions.TransitionExecutorService;
import io.atlassian.fugue.Either;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class WorkflowApprovalServiceImpl
implements WorkflowApprovalService {
    private final Logger logger = LoggerFactory.getLogger(WorkflowApprovalServiceImpl.class);
    private final WorkflowApprovalConfigurationManager workflowApprovalConfigurationManager;
    private final ApprovalError approvalError;
    private final TransitionExecutorService transitionExecutorService;
    private final InternalApprovalService approvalService;

    @Autowired
    public WorkflowApprovalServiceImpl(WorkflowApprovalConfigurationManager workflowApprovalConfigurationManager, ApprovalError approvalError, TransitionExecutorService transitionExecutorService, InternalApprovalService approvalService) {
        this.workflowApprovalConfigurationManager = workflowApprovalConfigurationManager;
        this.approvalError = approvalError;
        this.transitionExecutorService = transitionExecutorService;
        this.approvalService = approvalService;
    }

    @Override
    public Either<AnError, Boolean> handleApprovalCompletion(ApplicationUser user, Approval approval) {
        Either transitionUpdateEither = Steps.begin((Either)this.approvalService.getIssueForApproval(user, approval)).then(this.workflowApprovalConfigurationManager::getActiveConfigurationForIssue).then((issue, approvalConfiguration) -> this.isValidAutomaticTransition((Issue)issue, approval)).then((issue, approvalConfiguration, valid) -> this.getTransitionId((WorkflowApprovalConfiguration)approvalConfiguration, approval)).then((issue, approvalConfiguration, valid, transitionId) -> this.transitionExecutorService.executeTransition((Issue)issue, (int)transitionId, user)).yield((issue, approvalConfiguration, valid, transitionId, updated) -> updated);
        if (transitionUpdateEither.isLeft()) {
            this.logger.warn(String.format("Approval automatic transition wasn't executed, message: %s", ((AnError)transitionUpdateEither.left().get()).toString()));
        }
        return transitionUpdateEither;
    }

    private Either<AnError, Boolean> isValidAutomaticTransition(Issue issue, Approval approval) {
        if (StringUtils.equals((String)issue.getStatusId(), (String)approval.getStatusId())) {
            return Either.right((Object)true);
        }
        return Either.left((Object)this.approvalError.UNABLE_TO_PERFORM_TRANSITION());
    }

    private Either<AnError, Integer> getTransitionId(WorkflowApprovalConfiguration approvalConfiguration, Approval approval) {
        if (approval.getDecision().isDefined()) {
            String transitionId;
            switch ((ApprovalDecisionType)approval.getDecision().get()) {
                case APPROVED: {
                    transitionId = approvalConfiguration.getApprovedTransitionId();
                    break;
                }
                case REJECTED: {
                    transitionId = approvalConfiguration.getDeclinedTransitionId();
                    break;
                }
                default: {
                    return Either.left((Object)this.approvalError.INVALID_APPROVAL_DECISION());
                }
            }
            try {
                return Either.right((Object)Integer.valueOf(transitionId));
            }
            catch (Exception e) {
                return Either.left((Object)this.approvalError.APPROVAL_NOT_CONFIGURED());
            }
        }
        return Either.left((Object)this.approvalError.APPROVAL_DECISION_NOT_FOUND());
    }
}

