/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.approvals.internal.util;

import com.atlassian.servicedesk.plugins.approvals.internal.util.JiraCopiedWorkflowEditorTransitionConditionUtil;
import com.opensymphony.workflow.loader.ActionDescriptor;
import com.opensymphony.workflow.loader.ConditionDescriptor;
import com.opensymphony.workflow.loader.ConditionsDescriptor;
import com.opensymphony.workflow.loader.DescriptorFactory;
import com.opensymphony.workflow.loader.RestrictionDescriptor;
import io.atlassian.fugue.Option;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SDWorkflowTransitionConditionUtil {
    private static final String DEFAULT_POSITION = "1";
    private static final String SEPARATOR = ".";
    private static final String OPERATOR_AND = "AND";
    private static final String OPERATOR_OR = "OR";
    private static final String CLASS_NAME_KEY = "class.name";
    JiraCopiedWorkflowEditorTransitionConditionUtil origUtil;

    @Autowired
    public SDWorkflowTransitionConditionUtil(JiraCopiedWorkflowEditorTransitionConditionUtil origUtil) {
        this.origUtil = origUtil;
    }

    public String addANDConditionAtTheRootLevel(@Nonnull ActionDescriptor transition, @Nonnull ConditionDescriptor condition) {
        return this.addANDConditionAtTheRootLevelImpl(transition, condition);
    }

    public void deleteRootLevelConditionsByType(@Nonnull ActionDescriptor transition, @Nonnull Class<?> conditionType) {
        this.findAndDeleteRootLevelConditionsByTypeImpl(transition, conditionType);
    }

    private String addANDConditionAtTheRootLevelImpl(ActionDescriptor transition, ConditionDescriptor condition) {
        this.insertTopLevelANDIfTopLevelIsOR(transition);
        return this.origUtil.addCondition(transition, DEFAULT_POSITION, condition);
    }

    private void insertTopLevelANDIfTopLevelIsOR(ActionDescriptor transition) {
        ConditionsDescriptor conditionsDescriptor;
        RestrictionDescriptor restriction = transition.getRestriction();
        if (restriction != null && (conditionsDescriptor = restriction.getConditionsDescriptor()) != null && OPERATOR_OR.equals(conditionsDescriptor.getType())) {
            ArrayList<ConditionsDescriptor> childConditions = new ArrayList<ConditionsDescriptor>();
            childConditions.add(conditionsDescriptor);
            ConditionsDescriptor wrapperCondition = DescriptorFactory.getFactory().createConditionsDescriptor();
            wrapperCondition.setConditions(childConditions);
            wrapperCondition.setType(OPERATOR_AND);
            restriction.setConditionsDescriptor(wrapperCondition);
        }
    }

    private void findAndDeleteRootLevelConditionsByTypeImpl(ActionDescriptor transition, Class<?> conditionType) {
        Option<ConditionsDescriptor> rootLevelOpt = this.getRootLevelConditionsDescriptor(transition);
        if (rootLevelOpt.isEmpty()) {
            return;
        }
        ConditionsDescriptor rootConditions = (ConditionsDescriptor)rootLevelOpt.get();
        String conditionClassName = conditionType.getName();
        int count = this.getConditionsCountByClassName(conditionClassName, rootConditions);
        Option<String> position = this.findPositionOfFirstRootLevelConditionByClassName(conditionClassName, rootConditions);
        for (int loopCounter = 0; position.isDefined() && loopCounter < count; ++loopCounter) {
            this.deleteCondition(transition, (String)position.get());
            position = this.findPositionOfFirstRootLevelConditionByClassName(conditionClassName, rootConditions);
        }
    }

    private Option<ConditionsDescriptor> getRootLevelConditionsDescriptor(ActionDescriptor transition) {
        Option rootConditionsDescriptors = Option.option((Object)transition).flatMap(t -> Option.option((Object)t.getRestriction())).flatMap(restriction -> Option.option((Object)restriction.getConditionsDescriptor()));
        return rootConditionsDescriptors;
    }

    private int getConditionsCountByClassName(@Nonnull String conditionClassName, ConditionsDescriptor conditionsDescriptor) {
        int count = 0;
        List conditions = conditionsDescriptor.getConditions() == null ? Collections.emptyList() : conditionsDescriptor.getConditions();
        for (Object condition : conditions) {
            ConditionDescriptor singleCondition;
            if (!(condition instanceof ConditionDescriptor) || !this.isConditionOfType(singleCondition = (ConditionDescriptor)condition, conditionClassName)) continue;
            ++count;
        }
        return count;
    }

    private Option<String> findPositionOfFirstRootLevelConditionByClassName(@Nonnull String conditionClassName, ConditionsDescriptor conditionsDescriptor) {
        List conditions = conditionsDescriptor.getConditions();
        if (conditions == null) {
            return Option.none();
        }
        for (Object condition : conditions) {
            ConditionDescriptor singleCondition;
            if (!(condition instanceof ConditionDescriptor) || !this.isConditionOfType(singleCondition = (ConditionDescriptor)condition, conditionClassName)) continue;
            String leafPosition = this.getPositionOfCondition(conditions, condition);
            return Option.some((Object)leafPosition);
        }
        return Option.none();
    }

    private boolean isConditionOfType(ConditionDescriptor condition, String conditionClassName) {
        Object className = condition.getArgs().get(CLASS_NAME_KEY);
        return conditionClassName.equals(className);
    }

    private String getPositionOfCondition(List conditions, Object condition) {
        return String.valueOf(conditions.indexOf(condition) + 1);
    }

    private void deleteCondition(ActionDescriptor transition, String position) {
        this.foldOtherChildListOperatorToParent(transition, position);
        this.origUtil.deleteCondition(transition, position);
    }

    private void foldOtherChildListOperatorToParent(ActionDescriptor transition, String position) {
        ConditionsDescriptor cd;
        RestrictionDescriptor restriction = transition.getRestriction();
        if (restriction == null) {
            return;
        }
        ConditionsDescriptor conditionsDescriptor = this.origUtil.getParentConditionsDescriptor(restriction, position);
        if (conditionsDescriptor.getConditions().size() != 2) {
            return;
        }
        int positionOfToBeRemovedCondition = this.origUtil.getLastCount(position) - 1;
        int positionOfRemainingCondition = positionOfToBeRemovedCondition == 0 ? 1 : 0;
        Object remainingCondition = conditionsDescriptor.getConditions().get(positionOfRemainingCondition);
        if (remainingCondition instanceof ConditionsDescriptor && (cd = (ConditionsDescriptor)remainingCondition).getConditions() != null && !cd.getConditions().isEmpty()) {
            String type = cd.getType();
            if (this.origUtil.isRootCount(position) && (OPERATOR_AND.equals(type) || OPERATOR_OR.equals(type))) {
                conditionsDescriptor.setType(type);
            }
        }
    }
}

