/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.approvals.internal.util;

import com.atlassian.fugue.Either;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.api.ServiceDeskService;
import com.atlassian.servicedesk.api.approval.Approval;
import com.atlassian.servicedesk.api.permission.ServiceDeskPermissionService;
import com.atlassian.servicedesk.api.user.UserFactory;
import com.atlassian.servicedesk.internal.api.workflows.SDWorkflowService;
import com.atlassian.servicedesk.plugins.approvals.internal.approval.ApprovalImpl;
import com.atlassian.servicedesk.plugins.approvals.internal.approver.ApproverManager;
import com.atlassian.servicedesk.plugins.approvals.internal.util.ApprovalError;
import com.atlassian.util.concurrent.Assertions;
import io.atlassian.fugue.Eithers;
import io.atlassian.fugue.Unit;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ApprovalPermissionChecker {
    private final ServiceDeskService serviceDeskService;
    private final ServiceDeskPermissionService permissionService;
    private final ApprovalError approvalError;
    private final IssueManager issueManager;
    private final ApproverManager approverManager;
    private final SDWorkflowService sdWorkflowService;
    private final UserFactory userFactory;

    @Autowired
    public ApprovalPermissionChecker(ServiceDeskService serviceDeskService, ServiceDeskPermissionService permissionService, ApprovalError approvalError, IssueManager issueManager, ApproverManager approverManager, SDWorkflowService sdWorkflowService, UserFactory userFactory) {
        this.serviceDeskService = serviceDeskService;
        this.permissionService = permissionService;
        this.approvalError = approvalError;
        this.issueManager = issueManager;
        this.approverManager = approverManager;
        this.sdWorkflowService = sdWorkflowService;
        this.userFactory = userFactory;
    }

    public io.atlassian.fugue.Either<AnError, ApplicationUser> canApprove(ApplicationUser user, Approval approval) {
        Assertions.notNull((String)"ApplicationUser", (Object)user);
        Assertions.notNull((String)"Approval", (Object)approval);
        return this.checkApprovePermission(user, approval);
    }

    public io.atlassian.fugue.Either<AnError, ApplicationUser> canSetFinalDecision(ApplicationUser user, Approval approval) {
        Assertions.notNull((String)"ApplicationUser", (Object)user);
        Assertions.notNull((String)"Approval", (Object)approval);
        ApprovalImpl approvalImpl = (ApprovalImpl)approval;
        MutableIssue issue = this.issueManager.getIssueObject(Long.valueOf(approvalImpl.getIssueId()));
        return Steps.begin((io.atlassian.fugue.Either)StepsConverters.newerEither((Either)this.serviceDeskService.getServiceDeskForProject(user, issue.getProjectObject()))).then(servicedesk -> StepsConverters.newerEither((Either)this.permissionService.isAgent(user, servicedesk))).then((servicedesk, isAgent) -> Eithers.cond((boolean)isAgent, (Object)this.approvalError.ADMIN_AGENT_PERMISSION(), (Object)Unit.VALUE)).yield((servicedesk, isAgent, unit) -> user);
    }

    public io.atlassian.fugue.Either<AnError, ApplicationUser> canCreateApproval(ApplicationUser user, Issue issue) {
        Assertions.notNull((String)"ApplicationUser", (Object)user);
        Assertions.notNull((String)"Issue", (Object)issue);
        return Steps.begin((io.atlassian.fugue.Either)StepsConverters.newerEither((Either)this.serviceDeskService.getServiceDeskForProject(user, issue.getProjectObject()))).then(servicedesk -> StepsConverters.newerEither((Either)this.permissionService.isAgent(user, servicedesk))).then((servicedesk, isAgent) -> Eithers.cond((boolean)isAgent, (Object)this.approvalError.ADMIN_AGENT_PERMISSION(), (Object)Unit.VALUE)).yield((servicedesk, isAgent, unit) -> user);
    }

    public io.atlassian.fugue.Either<AnError, ApplicationUser> canConfigureApproval(ApplicationUser user, JiraWorkflow workflow) {
        Assertions.notNull((String)"ApplicationUser", (Object)user);
        return Steps.begin((io.atlassian.fugue.Either)StepsConverters.newerEither((Either)this.userFactory.wrap(user))).yield(checkedUser -> this.sdWorkflowService.hasEditWorkflowPermission(checkedUser, workflow)).bimap(error -> this.approvalError.CONFIGURE_APPROVAL_PERMISSION(), result -> user);
    }

    public boolean canViewApproval(ApplicationUser user) {
        return true;
    }

    public boolean canViewApprover(ApplicationUser user, Approval approval) {
        return true;
    }

    private io.atlassian.fugue.Either<AnError, ApplicationUser> checkApprovePermission(ApplicationUser user, Approval approval) {
        return Eithers.cond((boolean)this.approverManager.isApprover(user, approval), (Object)this.approvalError.APPROVE_PERMISSION(), (Object)user);
    }
}

