/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.approvals.internal.util;

import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.commons.jira.ErrorResultHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ApprovalError {
    private final ErrorResultHelper errorHelper;

    @Autowired
    public ApprovalError(ErrorResultHelper errorHelper) {
        this.errorHelper = errorHelper;
    }

    public AnError APPROVAL_NAME_TOO_LONG(int limit) {
        return this.errorHelper.badRequest400("sd.approval.error.name.too.long", new Object[]{limit}).build();
    }

    public AnError APPROVAL_NAME_REQUIRED() {
        return this.errorHelper.badRequest400("sd.approval.error.name.required", new Object[0]).build();
    }

    public AnError APPROVAL_DATABASE_CREATION_FAILED() {
        return this.errorHelper.internalServiceError500("sd.approval.error.failed.to.create.approval.in.database", new Object[0]).build();
    }

    public AnError INVALID_USER(String userKey) {
        return this.errorHelper.badRequest400("sd.approval.error.invalid.user", new Object[]{userKey}).build();
    }

    public AnError AT_LEAST_ONE_APPROVER() {
        return this.errorHelper.badRequest400("sd.approval.error.at.least.one.approver", new Object[0]).build();
    }

    public AnError NOT_APPROVER(String username) {
        return this.errorHelper.badRequest400("sd.approval.error.not.approver", new Object[]{username}).build();
    }

    public AnError APPROVAL_DECISION_WAS_SET() {
        return this.errorHelper.badRequest400("sd.approval.error.decision.was.set", new Object[0]).build();
    }

    public AnError APPROVER_HAS_MADE_DECISION() {
        return this.errorHelper.badRequest400("sd.approval.error.approver.already.made.decision", new Object[0]).build();
    }

    public AnError APPROVAL_NOT_FOUND() {
        return this.errorHelper.notFound404("sd.approval.error.approval.not.exist", new Object[0]).build();
    }

    public AnError CONFIGURE_APPROVAL_PERMISSION() {
        return this.errorHelper.unauthorized401("sd.approval.error.configure.approval.permission", new Object[0]).build();
    }

    public AnError ADMIN_AGENT_PERMISSION() {
        return this.errorHelper.unauthorized401("sd.approval.error.admin.agent.permission", new Object[0]).build();
    }

    public AnError VIEW_APPROVAL_PERMISSION() {
        return this.errorHelper.unauthorized401("sd.approval.error.view.approval.permission", new Object[0]).build();
    }

    public AnError VIEW_APPROVER_PERMISSION() {
        return this.errorHelper.unauthorized401("sd.approval.error.view.approver.permission", new Object[0]).build();
    }

    public AnError APPROVE_PERMISSION() {
        return this.errorHelper.forbidden403("sd.approval.error.approve.permission", new Object[0]).build();
    }

    public AnError APPROVAL_CONDITION_MUST_BE_SPECIFIED() {
        return this.errorHelper.badRequest400("sd.approval.error.condition.must.be.specified", new Object[0]).build();
    }

    public AnError INVALID_APPROVAL_CONDITION_VALUE() {
        return this.errorHelper.badRequest400("sd.approval.error.condition.invalid.value", new Object[0]).build();
    }

    public AnError NEGATIVE_APPROVAL_CONDITION_VALUE() {
        return this.errorHelper.badRequest400("sd.approval.error.condition.negative.value", new Object[0]).build();
    }

    public AnError INVALID_APPROVAL_CONDITION_VALUE_FOR_PERCENT() {
        return this.errorHelper.badRequest400("sd.approval.error.condition.invalid.percent.value", new Object[0]).build();
    }

    public AnError APPROVAL_INDEX_FAILED() {
        return this.errorHelper.internalServiceError500("sd.approval.error.index.failed", new Object[0]).build();
    }

    public AnError WORKFLOW_STATUS_NOT_FOUND() {
        return this.errorHelper.badRequest400("sd.approval.error.workflow.status.not.found", new Object[0]).build();
    }

    public AnError WORKFLOW_NOT_FOUND() {
        return this.errorHelper.badRequest400("sd.approval.error.workflow.not.found", new Object[0]).build();
    }

    public AnError WORKFLOW_SAVE_FAILED() {
        return this.errorHelper.internalServiceError500("sd.approval.error.workflow.save.failed", new Object[0]).build();
    }

    public AnError ISSUE_NOT_FOUND() {
        return this.errorHelper.badRequest400("sd.approval.error.issue.not.found", new Object[0]).build();
    }

    public AnError NO_PERMISSION_TO_VIEW_REQUEST() {
        return this.errorHelper.forbidden403("sd.approval.error.issue.not.authorized", new Object[0]).build();
    }

    public AnError APPROVAL_NOT_CONFIGURED() {
        return this.errorHelper.badRequest400("sd.approval.error.approval.not.configured", new Object[0]).build();
    }

    public AnError APPROVAL_NOT_BELONG_TO_STATUS() {
        return this.errorHelper.badRequest400("sd.approval.error.approval.not.belong.to.status", new Object[0]).build();
    }

    public AnError UNABLE_TO_PERFORM_TRANSITION() {
        return this.errorHelper.internalServiceError500("sd.approval.error.unable.to.perform.transition", new Object[0]).build();
    }

    public AnError APPROVAL_DECISION_NOT_FOUND() {
        return this.errorHelper.internalServiceError500("sd.approval.error.decision.not.found", new Object[0]).build();
    }

    public AnError INVALID_APPROVAL_DECISION() {
        return this.errorHelper.internalServiceError500("sd.approval.error.invalid.decision", new Object[0]).build();
    }

    public AnError INACTIVE_APPROVAL_CONFIGURATION() {
        return this.errorHelper.internalServiceError500("sd.approval.error.inactive.configuration", new Object[0]).build();
    }

    public AnError CUSTOM_FIELD_NOT_FOUND() {
        return this.errorHelper.badRequest400("sd.approval.error.approver.customfield.not.found", new Object[0]).build();
    }

    public AnError APPROVAL_QUERY_NOT_VALID() {
        return this.errorHelper.badRequest400("sd.approval.error.approval.query.not.valid", new Object[0]).build();
    }
}

