/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.approvals.internal.searcher.validator;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.jql.resolver.UserResolver;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.MessageSet;
import com.atlassian.jira.util.MessageSetImpl;
import java.util.List;

public class ApprovalUserArgumentValidator {
    private final UserResolver userResolver;

    public ApprovalUserArgumentValidator(UserResolver userResolver) {
        this.userResolver = userResolver;
    }

    public MessageSet validateRawUserValueInputs(ApplicationUser searcher, List<String> rawValues) {
        MessageSetImpl messageSet = new MessageSetImpl();
        I18nHelper i18nHelper = this.getI18n(searcher);
        if (rawValues.isEmpty()) {
            messageSet.addErrorMessage(i18nHelper.getText("sd.approvals.jql.function.invalid.approver.argument"));
        }
        rawValues.stream().forEach(arg_0 -> this.lambda$validateRawUserValueInputs$0((MessageSet)messageSet, i18nHelper, arg_0));
        return messageSet;
    }

    I18nHelper getI18n(ApplicationUser user) {
        return ComponentAccessor.getI18nHelperFactory().getInstance(user);
    }

    private /* synthetic */ void lambda$validateRawUserValueInputs$0(MessageSet messageSet, I18nHelper i18nHelper, String raw) {
        if (this.userResolver.getIdsFromName(raw).isEmpty()) {
            messageSet.addErrorMessage(i18nHelper.getText("sd.approvals.jql.function.invalid.approver.value", raw));
        }
    }
}

