/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.approvals.internal.searcher.query;

import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.jql.operand.JqlOperandResolver;
import com.atlassian.jira.jql.operand.QueryLiteral;
import com.atlassian.jira.jql.query.QueryFactoryResult;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.query.clause.TerminalClause;
import com.atlassian.servicedesk.plugins.approvals.internal.bootstrap.lifecycle.ApprovalComponentAccessor;
import com.atlassian.servicedesk.plugins.approvals.internal.searcher.index.ApprovalsCustomFieldIndexer;
import com.atlassian.servicedesk.plugins.approvals.internal.searcher.query.ApprovalsClauseQueryCreationService;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.springframework.stereotype.Component;

@Component
public class ApproverClauseQueryCreation
implements ApprovalsClauseQueryCreationService {
    @Override
    public QueryFactoryResult createQuery(ApplicationUser user, CustomField field, TerminalClause terminalClause) {
        List queryLiterals = this.getJqlOperandResolver().getValues(user, terminalClause.getOperand(), terminalClause);
        List queryFactoryResults = queryLiterals.stream().map(queryLiteral -> this.createQueryFromQueryLiteral((QueryLiteral)queryLiteral, field)).collect(Collectors.toList());
        return QueryFactoryResult.mergeResultsWithShould(queryFactoryResults);
    }

    private QueryFactoryResult createQueryFromQueryLiteral(QueryLiteral queryLiteral, CustomField customField) {
        TermQuery query = new TermQuery(new Term(ApprovalsCustomFieldIndexer.approverFieldId(customField), queryLiteral.getStringValue()));
        return new QueryFactoryResult((Query)query);
    }

    private JqlOperandResolver getJqlOperandResolver() {
        return ApprovalComponentAccessor.getJqlOperandResolver();
    }
}

