/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.approvals.internal.searcher.index;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.servicedesk.api.approval.Approval;
import com.atlassian.servicedesk.internal.api.approval.ApprovalState;
import com.atlassian.servicedesk.internal.api.decision.ApproverDecision;
import com.atlassian.servicedesk.plugins.approvals.internal.issue.ApprovalUserData;
import com.atlassian.servicedesk.plugins.approvals.internal.issue.IssueApprovalDataManager;
import com.atlassian.servicedesk.plugins.approvals.internal.issue.IssueApprovalUserData;
import com.atlassian.servicedesk.plugins.approvals.internal.searcher.index.ApprovalsIndexData;
import com.google.common.collect.Sets;
import io.atlassian.fugue.Option;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ApprovalsIndexerDataManager {
    private final IssueApprovalDataManager indexDataProvider;
    private final UserManager userManager;

    @Autowired
    public ApprovalsIndexerDataManager(IssueApprovalDataManager indexDataProvider, UserManager userManager) {
        this.indexDataProvider = indexDataProvider;
        this.userManager = userManager;
    }

    public Option<ApprovalsIndexData> getApprovalIndexDataForIssue(Issue issue) {
        ApprovalsIndexData.IndexDataBuilder builder = ApprovalsIndexData.builder();
        IssueApprovalUserData issueApprovalData = this.indexDataProvider.getIssueApprovalData(issue);
        Collection<ApprovalUserData> unProcessedDatas = issueApprovalData.getApprovalUserDatas();
        if (unProcessedDatas.isEmpty()) {
            return Option.none();
        }
        this.addApprovalStateAndDecisionIndex(builder, unProcessedDatas);
        this.addApproverIndex(builder, unProcessedDatas);
        this.addPendingByIndex(builder, unProcessedDatas);
        return Option.some((Object)builder.build());
    }

    private void addApprovalStateAndDecisionIndex(ApprovalsIndexData.IndexDataBuilder builder, Collection<ApprovalUserData> unProcessedDatas) {
        Collection<Approval> approvals = this.getAllApprovals(unProcessedDatas);
        HashSet states = Sets.newHashSet();
        HashSet decisionTypes = Sets.newHashSet();
        approvals.stream().forEach(approval -> {
            if (approval.getDecision().isDefined()) {
                states.add(ApprovalState.DONE);
                decisionTypes.add(approval.getDecision().get());
            } else {
                states.add(ApprovalState.PENDING);
            }
        });
        builder.setState(states);
        builder.setDecisionTypes(decisionTypes);
    }

    private void addApproverIndex(ApprovalsIndexData.IndexDataBuilder builder, Collection<ApprovalUserData> unProcessedDatas) {
        HashSet approvers = Sets.newHashSet();
        approvers.addAll(this.getCurrentApprovers(unProcessedDatas));
        approvers.addAll(this.getApproversWhoMadeDecision(unProcessedDatas));
        builder.setApprovers(approvers);
    }

    private void addPendingByIndex(ApprovalsIndexData.IndexDataBuilder builder, Collection<ApprovalUserData> unProcessedDatas) {
        Set<ApplicationUser> pendingApprovers = this.getPendingApprovers(unProcessedDatas);
        builder.setPendingByApprovers(pendingApprovers);
    }

    private Collection<Approval> getAllApprovals(Collection<ApprovalUserData> unProcessedDatas) {
        return unProcessedDatas.stream().map(data -> data.getApproval()).collect(Collectors.toList());
    }

    private Set<ApplicationUser> getCurrentApprovers(Collection<ApprovalUserData> unProcessedDatas) {
        HashSet approvers = Sets.newHashSet();
        unProcessedDatas.stream().forEach(data -> approvers.addAll(data.getApprovers()));
        return approvers;
    }

    private Set<ApplicationUser> getApproversWhoMadeDecision(Collection<ApprovalUserData> unProcessedDatas) {
        HashSet approversWhoMadeDecision = Sets.newHashSet();
        for (ApprovalUserData unProcessData : unProcessedDatas) {
            Set<ApplicationUser> usersWhoMadeDecisionPerApproval = this.getUserWhoMadeDecision(unProcessData);
            approversWhoMadeDecision.addAll(usersWhoMadeDecisionPerApproval);
        }
        return approversWhoMadeDecision;
    }

    private Set<ApplicationUser> getPendingApprovers(Collection<ApprovalUserData> unProcessedDatas) {
        HashSet pendingApprovers = Sets.newHashSet();
        List activeApprovalIndexData = unProcessedDatas.stream().filter(data -> data.getApproval().getDecision().isEmpty()).collect(Collectors.toList());
        for (ApprovalUserData unProcessData : activeApprovalIndexData) {
            Set<ApplicationUser> usersWhoMadeDecisionPerApproval = this.getUserWhoMadeDecision(unProcessData);
            Set<ApplicationUser> usersPerApproval = unProcessData.getApprovers();
            Set<ApplicationUser> userWhoHaventMadeDecisionPerApproval = this.getUserWhoHaventMadeDecision(usersPerApproval, usersWhoMadeDecisionPerApproval);
            pendingApprovers.addAll(userWhoHaventMadeDecisionPerApproval);
        }
        return pendingApprovers;
    }

    private Set<ApplicationUser> getUserWhoHaventMadeDecision(Set<ApplicationUser> usersPerApproval, Set<ApplicationUser> usersWhoMadeDecisionPerApproval) {
        return usersPerApproval.stream().filter(user -> !usersWhoMadeDecisionPerApproval.contains(user)).collect(Collectors.toSet());
    }

    private Set<ApplicationUser> getUserWhoMadeDecision(ApprovalUserData unProcessData) {
        Set<ApproverDecision> approverDecisions = unProcessData.getApproverDecisions();
        Set<ApplicationUser> users = approverDecisions.stream().map(decision -> this.userManager.getUserByKey(decision.getUserKey())).filter(user -> user != null).collect(Collectors.toSet());
        return users;
    }
}

