/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.approvals.internal.searcher.index;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.index.indexers.impl.AbstractCustomFieldIndexer;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.web.FieldVisibilityManager;
import com.atlassian.pocketknife.annotations.lucene.LuceneUsage;
import com.atlassian.servicedesk.api.approval.ApprovalDecisionType;
import com.atlassian.servicedesk.internal.api.approval.ApprovalState;
import com.atlassian.servicedesk.plugins.approvals.internal.searcher.index.ApprovalsIndexData;
import com.atlassian.servicedesk.plugins.approvals.internal.searcher.index.ApprovalsIndexerDataManager;
import com.atlassian.servicedesk.plugins.approvals.internal.util.ApprovalDecisionTypeValueHelper;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;

@LuceneUsage(type=LuceneUsage.LuceneUsageType.Indexer)
public class ApprovalsCustomFieldIndexer
extends AbstractCustomFieldIndexer {
    private final ApprovalsIndexerDataManager indexerDataHelper;
    private final CustomField field;

    public ApprovalsCustomFieldIndexer(FieldVisibilityManager fieldVisibilityManager, CustomField customField, ApprovalsIndexerDataManager indexerDataHelper) {
        super(fieldVisibilityManager, customField);
        this.indexerDataHelper = indexerDataHelper;
        this.field = customField;
    }

    public void addDocumentFieldsSearchable(Document doc, Issue issue) {
        this.addDocumentFields(doc, issue);
    }

    public void addDocumentFieldsNotSearchable(Document doc, Issue issue) {
        this.addDocumentFields(doc, issue);
    }

    private void addDocumentFields(Document doc, Issue issue) {
        this.indexerDataHelper.getApprovalIndexDataForIssue(issue).forEach(indexData -> {
            this.indexStateData((ApprovalsIndexData)indexData, doc);
            this.indexDecisionData((ApprovalsIndexData)indexData, doc);
            this.indexApproversData((ApprovalsIndexData)indexData, doc);
            this.indexPendingApproverData((ApprovalsIndexData)indexData, doc);
        });
    }

    private void indexStateData(ApprovalsIndexData indexData, Document document) {
        Set<ApprovalState> states = indexData.getState();
        for (ApprovalState state : states) {
            document.add((Fieldable)new Field(ApprovalsCustomFieldIndexer.approvalStateFieldId(this.field), state.value(), Field.Store.NO, Field.Index.NOT_ANALYZED));
        }
    }

    private void indexDecisionData(ApprovalsIndexData indexData, Document doc) {
        Set<ApprovalDecisionType> decisionTypes = indexData.getDecisionTypes();
        decisionTypes.forEach(decisionType -> doc.add((Fieldable)new Field(ApprovalsCustomFieldIndexer.approvalDecisionFieldId(this.field), ApprovalDecisionTypeValueHelper.toDatabaseValue(decisionType), Field.Store.NO, Field.Index.NOT_ANALYZED)));
    }

    private void indexApproversData(ApprovalsIndexData indexData, Document document) {
        Set<String> approverUserKeys = indexData.getApprovers().stream().map(ApplicationUser::getKey).collect(Collectors.toSet());
        approverUserKeys.forEach(userKey -> document.add((Fieldable)new Field(ApprovalsCustomFieldIndexer.approverFieldId(this.field), userKey, Field.Store.NO, Field.Index.NOT_ANALYZED)));
    }

    private void indexPendingApproverData(ApprovalsIndexData indexData, Document doc) {
        Set<String> approverUserKeys = indexData.getPendingByApprovers().stream().map(ApplicationUser::getKey).collect(Collectors.toSet());
        approverUserKeys.forEach(userKey -> doc.add((Fieldable)new Field(ApprovalsCustomFieldIndexer.pendingByFieldId(this.field), userKey, Field.Store.NO, Field.Index.NOT_ANALYZED)));
    }

    public static String approvalStateFieldId(CustomField field) {
        return field.getId() + "_state";
    }

    public static String approvalDecisionFieldId(CustomField field) {
        return field.getId() + "_decision";
    }

    public static String approverFieldId(CustomField field) {
        return field.getId() + "_approver";
    }

    public static String pendingByFieldId(CustomField field) {
        return field.getId() + "_pendingBy";
    }
}

