/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.approvals.internal.searcher.function;

import com.atlassian.jira.jql.operand.QueryLiteral;
import com.atlassian.jira.jql.query.QueryCreationContext;
import com.atlassian.jira.jql.resolver.UserResolver;
import com.atlassian.jira.jql.validator.SupportedOperatorsValidator;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.MessageSet;
import com.atlassian.jira.util.MessageSetImpl;
import com.atlassian.query.clause.TerminalClause;
import com.atlassian.query.operand.FunctionOperand;
import com.atlassian.query.operand.Operand;
import com.atlassian.query.operator.Operator;
import com.atlassian.servicedesk.plugins.approvals.internal.searcher.function.ApprovalsJqlFunction;
import com.atlassian.servicedesk.plugins.approvals.internal.searcher.validator.ApprovalUserArgumentValidator;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public abstract class ApprovalUserArgumentJqlFunction
extends ApprovalsJqlFunction {
    private final UserResolver userResolver;

    public ApprovalUserArgumentJqlFunction(UserResolver userResolver) {
        this.userResolver = userResolver;
    }

    @Nonnull
    public MessageSet validate(ApplicationUser searcher, @Nonnull FunctionOperand operand, @Nonnull TerminalClause terminalClause) {
        MessageSetImpl messageSet = new MessageSetImpl();
        messageSet.addMessageSet(this.validateOperators(searcher, terminalClause));
        messageSet.addMessageSet(this.validateRawValueInputs(searcher, operand.getArgs()));
        return messageSet;
    }

    @Nonnull
    public List<QueryLiteral> getValues(@Nonnull QueryCreationContext queryCreationContext, @Nonnull FunctionOperand operand, @Nonnull TerminalClause terminalClause) {
        Set<String> userKeys = this.getUserKeyFromRawValues(operand.getArgs());
        List<QueryLiteral> queryLiterals = userKeys.stream().map(userKey -> new QueryLiteral((Operand)operand, userKey)).collect(Collectors.toList());
        return queryLiterals;
    }

    public int getMinimumNumberOfExpectedArguments() {
        return 1;
    }

    private Set<String> getUserKeyFromRawValues(List<String> rawValues) {
        HashSet userKeys = Sets.newHashSet();
        rawValues.stream().forEach(rawValue -> userKeys.addAll(this.userResolver.getIdsFromName(rawValue)));
        return userKeys;
    }

    private MessageSet validateOperators(ApplicationUser searcher, TerminalClause terminalClause) {
        EnumSet<Operator> supportedOperators = EnumSet.of(Operator.EQUALS);
        MessageSet messageSet = new SupportedOperatorsValidator(new Collection[]{supportedOperators}).validate(searcher, terminalClause);
        return messageSet;
    }

    private MessageSet validateRawValueInputs(ApplicationUser searcher, List<String> rawValues) {
        ApprovalUserArgumentValidator validator = new ApprovalUserArgumentValidator(this.userResolver);
        return validator.validateRawUserValueInputs(searcher, rawValues);
    }
}

