/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.approvals.internal.searcher;

import com.atlassian.jira.issue.customfields.CustomFieldValueProvider;
import com.atlassian.jira.issue.customfields.SingleValueCustomFieldValueProvider;
import com.atlassian.jira.issue.customfields.searchers.AbstractInitializationCustomFieldSearcher;
import com.atlassian.jira.issue.customfields.searchers.CustomFieldSearcherClauseHandler;
import com.atlassian.jira.issue.customfields.searchers.SimpleCustomFieldSearcherClauseHandler;
import com.atlassian.jira.issue.customfields.searchers.information.CustomFieldSearcherInformation;
import com.atlassian.jira.issue.customfields.searchers.renderer.CustomFieldRenderer;
import com.atlassian.jira.issue.customfields.searchers.transformer.CustomFieldInputHelper;
import com.atlassian.jira.issue.customfields.searchers.transformer.FreeTextCustomFieldSearchInputTransformer;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.search.ClauseNames;
import com.atlassian.jira.issue.search.searchers.information.SearcherInformation;
import com.atlassian.jira.issue.search.searchers.renderer.SearchRenderer;
import com.atlassian.jira.issue.search.searchers.transformer.SearchInputTransformer;
import com.atlassian.jira.jql.query.ClauseQueryFactory;
import com.atlassian.jira.jql.validator.ClauseValidator;
import com.atlassian.jira.web.FieldVisibilityManager;
import com.atlassian.query.operator.Operator;
import com.atlassian.servicedesk.plugins.approvals.internal.bootstrap.lifecycle.ApprovalComponentAccessor;
import com.atlassian.servicedesk.plugins.approvals.internal.searcher.ApprovalsClauseQueryFactory;
import com.atlassian.servicedesk.plugins.approvals.internal.searcher.ApprovalsClauseValidator;
import com.atlassian.servicedesk.plugins.approvals.internal.searcher.ApprovalsDataTypes;
import com.atlassian.servicedesk.plugins.approvals.internal.searcher.index.ApprovalsCustomFieldIndexer;
import com.atlassian.servicedesk.plugins.approvals.internal.searcher.index.ApprovalsIndexerDataManager;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;

public class ApprovalsSearcher
extends AbstractInitializationCustomFieldSearcher {
    private volatile CustomFieldSearcherInformation searcherInformation;
    private volatile SearchInputTransformer searchInputTransformer;
    private volatile SearchRenderer searchRenderer;
    private volatile CustomFieldSearcherClauseHandler customFieldSearcherClauseHandler;
    private final FieldVisibilityManager fieldVisibilityManager;
    private final CustomFieldInputHelper customFieldInputHelper;

    public ApprovalsSearcher(FieldVisibilityManager fieldVisibilityManager, CustomFieldInputHelper customFieldInputHelper) {
        this.fieldVisibilityManager = fieldVisibilityManager;
        this.customFieldInputHelper = customFieldInputHelper;
    }

    public void init(CustomField field) {
        ApprovalsIndexerDataManager indexerDataHelper = ApprovalComponentAccessor.getApprovalIndexerDataHelper();
        ApprovalsCustomFieldIndexer indexer = new ApprovalsCustomFieldIndexer(this.fieldVisibilityManager, field, indexerDataHelper);
        this.searcherInformation = new CustomFieldSearcherInformation(field.getId(), field.getNameKey(), Collections.singletonList(indexer), new AtomicReference<CustomField>(field));
        ClauseNames clauseNames = field.getClauseNames();
        SingleValueCustomFieldValueProvider valueProvider = new SingleValueCustomFieldValueProvider();
        this.searchRenderer = new CustomFieldRenderer(clauseNames, this.getDescriptor(), field, (CustomFieldValueProvider)valueProvider, this.fieldVisibilityManager);
        this.searchInputTransformer = new FreeTextCustomFieldSearchInputTransformer(field, clauseNames, this.searcherInformation.getId(), this.customFieldInputHelper);
        ApprovalsClauseValidator approvalsClauseValidator = new ApprovalsClauseValidator();
        ApprovalsClauseQueryFactory approvalsClauseQueryFactory = new ApprovalsClauseQueryFactory(field);
        this.customFieldSearcherClauseHandler = new SimpleCustomFieldSearcherClauseHandler((ClauseValidator)approvalsClauseValidator, (ClauseQueryFactory)approvalsClauseQueryFactory, this.getSupportedOperators(), ApprovalsDataTypes.APPROVALS_FUNCTION);
    }

    public SearcherInformation<CustomField> getSearchInformation() {
        if (this.searcherInformation == null) {
            throw new IllegalStateException("Attempt to retrieve SearcherInformation of uninitialised custom field searcher.");
        }
        return this.searcherInformation;
    }

    public SearchInputTransformer getSearchInputTransformer() {
        if (this.searchInputTransformer == null) {
            throw new IllegalStateException("Attempt to retrieve searchInputTransformer of uninitialised custom field searcher.");
        }
        return this.searchInputTransformer;
    }

    public SearchRenderer getSearchRenderer() {
        if (this.searchRenderer == null) {
            throw new IllegalStateException("Attempt to retrieve searchRenderer of uninitialised custom field searcher.");
        }
        return this.searchRenderer;
    }

    public CustomFieldSearcherClauseHandler getCustomFieldSearcherClauseHandler() {
        if (this.customFieldSearcherClauseHandler == null) {
            throw new IllegalStateException("Attempt to retrieve customFieldSearcherClauseHandler of uninitialised custom field searcher.");
        }
        return this.customFieldSearcherClauseHandler;
    }

    private Set<Operator> getSupportedOperators() {
        return EnumSet.of(Operator.EQUALS);
    }
}

