/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.approvals.internal.rest.workflow;

import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.servicedesk.internal.api.ServiceDeskManager;
import com.atlassian.servicedesk.internal.api.util.WorkflowHelper;
import com.atlassian.servicedesk.plugins.approvals.internal.customfield.ApprovalsCFTypeCheckerService;
import com.atlassian.servicedesk.plugins.approvals.internal.rest.response.EligbleFieldResponse;
import com.atlassian.servicedesk.plugins.approvals.internal.rest.workflow.request.WorkflowApprovalRequest;
import com.atlassian.servicedesk.plugins.approvals.internal.rest.workflow.response.TransitionResponse;
import com.atlassian.servicedesk.plugins.approvals.internal.rest.workflow.response.WorkflowApprovalConfigurationResponse;
import com.atlassian.servicedesk.plugins.approvals.internal.rest.workflow.response.WorkflowStepConfigurationResponse;
import com.atlassian.servicedesk.plugins.approvals.internal.rest.workflow.response.WorkflowStepOptionsResponse;
import com.atlassian.servicedesk.plugins.approvals.internal.util.ApprovalError;
import com.atlassian.servicedesk.plugins.approvals.internal.util.ApprovalFieldsProvider;
import com.atlassian.servicedesk.plugins.approvals.internal.workflow.configuration.WorkflowApprovalConfiguration;
import com.atlassian.servicedesk.plugins.approvals.internal.workflow.configuration.WorkflowApprovalConfigurationService;
import com.atlassian.servicedesk.plugins.approvals.internal.workflow.configuration.WorkflowApprovalConfigurationUpdateOptions;
import com.opensymphony.workflow.loader.StepDescriptor;
import com.opensymphony.workflow.loader.WorkflowDescriptor;
import io.atlassian.fugue.Either;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class WorkflowApprovalAssembler {
    private final ApprovalError approvalError;
    private final WorkflowHelper workflowHelper;
    private final WorkflowApprovalConfigurationService approvalConfigurationService;
    private final ApprovalFieldsProvider approvalFieldsProvider;
    private final ServiceDeskManager serviceDeskManager;
    private final ApprovalsCFTypeCheckerService cfTypeCheckerService;

    @Autowired
    public WorkflowApprovalAssembler(ApprovalError approvalError, WorkflowHelper workflowHelper, WorkflowApprovalConfigurationService approvalConfigurationService, ApprovalFieldsProvider approvalFieldsProvider, ServiceDeskManager serviceDeskManager, ApprovalsCFTypeCheckerService cfTypeCheckerService) {
        this.approvalError = approvalError;
        this.workflowHelper = workflowHelper;
        this.approvalConfigurationService = approvalConfigurationService;
        this.approvalFieldsProvider = approvalFieldsProvider;
        this.serviceDeskManager = serviceDeskManager;
        this.cfTypeCheckerService = cfTypeCheckerService;
    }

    public Either<AnError, WorkflowApprovalConfigurationResponse> getConfigurations(ApplicationUser user, String workflowName) {
        return Steps.begin((Either)this.workflowHelper.getDraftWorkflow(user, workflowName)).then(draftWorkflow -> this.approvalConfigurationService.getConfigurations(user, (JiraWorkflow)draftWorkflow)).yield(this::buildWorkflowConfigurationResponse);
    }

    public Either<AnError, WorkflowStepConfigurationResponse> updateConfiguration(ApplicationUser user, String workflowName, long statusId, WorkflowApprovalRequest configureApprovalRequest) {
        return Steps.begin((Either)this.workflowHelper.getDraftWorkflow(user, workflowName)).then(draftWorkflow -> this.workflowHelper.getStepByStatusId(draftWorkflow, statusId)).then((draftWorkflow, stepDescriptor) -> this.approvalConfigurationService.updateConfiguration(user, (JiraWorkflow)draftWorkflow, (StepDescriptor)stepDescriptor, new WorkflowApprovalConfigurationUpdateOptions(configureApprovalRequest.getCustomFieldId(), configureApprovalRequest.getApprovedTransitionId(), configureApprovalRequest.getDeclinedTransitionId(), configureApprovalRequest.getConditionType(), configureApprovalRequest.getConditionValue()))).yield((draftWorkflow, stepDescriptor, updatedConfiguration) -> new WorkflowStepConfigurationResponse(workflowName, (WorkflowApprovalConfiguration)updatedConfiguration));
    }

    public Either<AnError, WorkflowStepConfigurationResponse> getConfiguration(ApplicationUser user, String workflowName, long statusId) {
        return Steps.begin((Either)this.workflowHelper.getDraftWorkflow(user, workflowName)).then(draftWorkflow -> this.workflowHelper.getStepByStatusId(draftWorkflow, statusId)).then((draftWorkflow, stepDescriptor) -> (Either)this.approvalConfigurationService.getConfiguration(user, (JiraWorkflow)draftWorkflow, (StepDescriptor)stepDescriptor).fold(Either::left, configurationOption -> (Either)configurationOption.fold(() -> Either.left((Object)this.approvalError.APPROVAL_NOT_CONFIGURED()), Either::right))).yield((draftWorkflow, stepDescriptor, configuration) -> new WorkflowStepConfigurationResponse(workflowName, (WorkflowApprovalConfiguration)configuration));
    }

    public Either<AnError, WorkflowApprovalConfiguration> deactivateConfiguration(ApplicationUser user, String workflowName, long statusId) {
        return Steps.begin((Either)this.workflowHelper.getDraftWorkflow(user, workflowName)).then(draftWorkflow -> this.workflowHelper.getStepByStatusId(draftWorkflow, statusId)).then((draftWorkflow, stepDescriptor) -> this.approvalConfigurationService.deactivateConfiguration(user, (JiraWorkflow)draftWorkflow, (StepDescriptor)stepDescriptor)).yield((draftWorkflow, stepDescriptor, configDeactivated) -> configDeactivated);
    }

    public Either<AnError, WorkflowApprovalConfiguration> activateConfiguration(ApplicationUser user, String workflowName, long statusId) {
        return Steps.begin((Either)this.workflowHelper.getDraftWorkflow(user, workflowName)).then(draftWorkflow -> this.workflowHelper.getStepByStatusId(draftWorkflow, statusId)).then((draftWorkflow, stepDescriptor) -> this.approvalConfigurationService.activateConfiguration(user, (JiraWorkflow)draftWorkflow, (StepDescriptor)stepDescriptor)).yield((draftWorkflow, stepDescriptor, configActivated) -> configActivated);
    }

    public Either<AnError, WorkflowStepOptionsResponse> getApprovalConfigurationOptions(ApplicationUser user, String workflowName, long statusId) {
        return Steps.begin((Either)this.workflowHelper.getDraftWorkflow(user, workflowName)).then(draftWorkflow -> this.workflowHelper.getStepByStatusId(draftWorkflow, statusId)).yield((draftWorkflow, stepDescriptor) -> {
            WorkflowDescriptor workflowDescriptor = draftWorkflow.getDescriptor();
            List<EligbleFieldResponse> eligibleFields = this.getEligibleFields(user);
            List<TransitionResponse> transitions = this.getTransitions(workflowDescriptor, (StepDescriptor)stepDescriptor);
            return new WorkflowStepOptionsResponse(eligibleFields, transitions);
        });
    }

    private WorkflowApprovalConfigurationResponse buildWorkflowConfigurationResponse(JiraWorkflow workflow, List<WorkflowApprovalConfiguration> configurations) {
        List<WorkflowStepConfigurationResponse> workflowStepConfigurationResponses = configurations.stream().map(config -> new WorkflowStepConfigurationResponse(workflow.getName(), (WorkflowApprovalConfiguration)config)).collect(Collectors.toList());
        List projects = this.workflowHelper.getProjectsForWorkflow(workflow.getName());
        boolean projectTypeSD = projects.stream().anyMatch(project -> this.serviceDeskManager.getServiceDeskForProject(project).isRight());
        boolean projectTypeOther = projects.stream().anyMatch(project -> this.serviceDeskManager.getServiceDeskForProject(project).isLeft());
        return new WorkflowApprovalConfigurationResponse(workflowStepConfigurationResponses, projectTypeSD, projectTypeOther);
    }

    private List<EligbleFieldResponse> getEligibleFields(ApplicationUser user) {
        return this.approvalFieldsProvider.getEligibleFields(user).stream().map(cf -> new EligbleFieldResponse(cf.getId(), cf.getName(), this.cfTypeCheckerService.isSingleUserCustomField(cf))).collect(Collectors.toList());
    }

    private List<TransitionResponse> getTransitions(WorkflowDescriptor workflowDescriptor, StepDescriptor stepDescriptor) {
        List actions = stepDescriptor.getActions();
        List globalActions = workflowDescriptor.getGlobalActions();
        ArrayList allActions = new ArrayList();
        allActions.addAll(actions);
        allActions.addAll(globalActions);
        return allActions.stream().map(action -> new TransitionResponse(action.getId(), action.getName())).collect(Collectors.toList());
    }
}

