/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.approvals.internal.rest;

import com.atlassian.jira.issue.fields.FieldException;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.commons.error.ErrorCode;
import com.atlassian.servicedesk.internal.api.rest.RestResponseHelper;
import com.atlassian.servicedesk.plugins.approvals.internal.rest.ApprovalAssembler;
import com.atlassian.servicedesk.plugins.approvals.internal.rest.request.CreateApprovalRequest;
import java.util.function.Function;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Path(value="approval")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class ApprovalResource {
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final ApprovalAssembler approvalAssembler;
    private final RestResponseHelper restResponseHelper;
    private static final Function<AnError, AnError> ANERROR_WITH_MESSAGE_AS_REASON_KEY = anError -> new AnError(anError.getMessage(), anError.getHttpStatusCode(), new ErrorCode(anError.getMessage().getMessage()));

    public ApprovalResource(JiraAuthenticationContext jiraAuthenticationContext, ApprovalAssembler approvalAssembler, RestResponseHelper restResponseHelper) {
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.approvalAssembler = approvalAssembler;
        this.restResponseHelper = restResponseHelper;
    }

    @GET
    @Path(value="/request/{issueKey}/create")
    public Response getCreateApprovalConfig(@PathParam(value="issueKey") String issueKey) throws FieldException {
        return this.restResponseHelper.anErrorEitherToOkResponse(this.approvalAssembler.getCreateApprovalConfig(this.getApplicationUser()).leftMap(ANERROR_WITH_MESSAGE_AS_REASON_KEY));
    }

    @POST
    @Path(value="/request/{issueKey}/create")
    public Response createApproval(@PathParam(value="issueKey") String issueKey, CreateApprovalRequest createApprovalRequest) {
        return this.restResponseHelper.anErrorEitherToOkResponse(this.approvalAssembler.createApproval(this.getApplicationUser(), issueKey, createApprovalRequest).leftMap(ANERROR_WITH_MESSAGE_AS_REASON_KEY));
    }

    @GET
    @Path(value="/request/{issueKey}/active")
    public Response getActiveApprovalForCurrentUser(@PathParam(value="issueKey") String issueKey) {
        return this.restResponseHelper.anErrorEitherToOkResponse(this.approvalAssembler.getActiveApprovalForCurrentUser(this.getApplicationUser(), issueKey).leftMap(ANERROR_WITH_MESSAGE_AS_REASON_KEY));
    }

    @GET
    @Path(value="/request/{issueKey}/checkactive")
    public Response checkActiveApproval(@PathParam(value="issueKey") String issueKey) {
        return this.restResponseHelper.anErrorEitherToOkResponse(this.approvalAssembler.checkActiveApproval(this.getApplicationUser(), issueKey).leftMap(ANERROR_WITH_MESSAGE_AS_REASON_KEY));
    }

    @GET
    @Path(value="/{approvalId}/approvers/decisions")
    public Response getApproversDecisions(@PathParam(value="approvalId") int approvalId) {
        return this.restResponseHelper.anErrorEitherToOkResponse(this.approvalAssembler.getApproversDecisions(this.getApplicationUser(), approvalId).leftMap(ANERROR_WITH_MESSAGE_AS_REASON_KEY));
    }

    @POST
    @Path(value="/{approvalId}/approve")
    public Response approveApproval(@PathParam(value="approvalId") Integer approvalId) {
        return this.restResponseHelper.anErrorEitherToOkResponse(this.approvalAssembler.approveApproval(this.getApplicationUser(), approvalId).leftMap(ANERROR_WITH_MESSAGE_AS_REASON_KEY));
    }

    @POST
    @Path(value="/{approvalId}/reject")
    public Response rejectApproval(@PathParam(value="approvalId") int approvalId) {
        return this.restResponseHelper.anErrorEitherToOkResponse(this.approvalAssembler.rejectApproval(this.getApplicationUser(), approvalId).leftMap(ANERROR_WITH_MESSAGE_AS_REASON_KEY));
    }

    private ApplicationUser getApplicationUser() {
        return this.jiraAuthenticationContext.getLoggedInUser();
    }
}

