/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.approvals.internal.rest;

import com.atlassian.jira.bc.issue.IssueService;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.servicedesk.api.approval.Approval;
import com.atlassian.servicedesk.api.approval.ApprovalDecisionType;
import com.atlassian.servicedesk.internal.api.approval.CreateApprovalParameters;
import com.atlassian.servicedesk.internal.api.approval.InternalApprovalService;
import com.atlassian.servicedesk.internal.api.approver.ApproverConfigurationDataInput;
import com.atlassian.servicedesk.internal.api.approver.InternalApproverService;
import com.atlassian.servicedesk.internal.api.decision.ApproverDecision;
import com.atlassian.servicedesk.internal.api.decision.ApproverDecisionParameters;
import com.atlassian.servicedesk.internal.api.decision.InternalApproverDecisionService;
import com.atlassian.servicedesk.internal.api.requirement.ApprovalCondition;
import com.atlassian.servicedesk.plugins.approvals.internal.approval.ApprovalImpl;
import com.atlassian.servicedesk.plugins.approvals.internal.approver.CustomFieldApproverTypeConfigurationHandler;
import com.atlassian.servicedesk.plugins.approvals.internal.approver.UserApproverTypeConfigurationHandler;
import com.atlassian.servicedesk.plugins.approvals.internal.customfield.ApprovalsCFTypeCheckerService;
import com.atlassian.servicedesk.plugins.approvals.internal.requirement.ApprovalConditionImpl;
import com.atlassian.servicedesk.plugins.approvals.internal.rest.request.ApproverRequest;
import com.atlassian.servicedesk.plugins.approvals.internal.rest.request.CreateApprovalRequest;
import com.atlassian.servicedesk.plugins.approvals.internal.rest.response.ApprovalCreateResponse;
import com.atlassian.servicedesk.plugins.approvals.internal.rest.response.ApprovalResponse;
import com.atlassian.servicedesk.plugins.approvals.internal.rest.response.ApproverDecisionCollectionResponse;
import com.atlassian.servicedesk.plugins.approvals.internal.rest.response.ApproverDecisionResponse;
import com.atlassian.servicedesk.plugins.approvals.internal.rest.response.EligbleFieldResponse;
import com.atlassian.servicedesk.plugins.approvals.internal.util.ApprovalError;
import com.atlassian.servicedesk.plugins.approvals.internal.util.ApprovalFieldsProvider;
import io.atlassian.fugue.Either;
import io.atlassian.fugue.Option;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ApprovalAssembler {
    private final InternalApprovalService approvalService;
    private final InternalApproverService approverService;
    private final ApprovalError approvalError;
    private final IssueService issueService;
    private final InternalApproverDecisionService approverDecisionService;
    private final ApprovalFieldsProvider approvalFieldsProvider;
    private final CustomFieldApproverTypeConfigurationHandler customFieldApproverTypeConfigurationHandler;
    private final UserApproverTypeConfigurationHandler userApproverTypeConfigurationHandler;
    private final ApprovalsCFTypeCheckerService cfTypeCheckerService;

    @Autowired
    public ApprovalAssembler(InternalApprovalService approvalService, InternalApproverService approverService, ApprovalError approvalError, IssueService issueService, InternalApproverDecisionService approverDecisionService, ApprovalFieldsProvider approvalFieldsProvider, CustomFieldApproverTypeConfigurationHandler customFieldApproverTypeConfigurationHandler, UserApproverTypeConfigurationHandler userApproverTypeConfigurationHandler, ApprovalsCFTypeCheckerService cfTypeCheckerService) {
        this.approvalService = approvalService;
        this.approverService = approverService;
        this.approvalError = approvalError;
        this.issueService = issueService;
        this.approverDecisionService = approverDecisionService;
        this.approvalFieldsProvider = approvalFieldsProvider;
        this.customFieldApproverTypeConfigurationHandler = customFieldApproverTypeConfigurationHandler;
        this.userApproverTypeConfigurationHandler = userApproverTypeConfigurationHandler;
        this.cfTypeCheckerService = cfTypeCheckerService;
    }

    public Either<AnError, ApprovalCreateResponse> getCreateApprovalConfig(ApplicationUser user) {
        List<EligbleFieldResponse> eligibleFields = this.approvalFieldsProvider.getEligibleFields(user).stream().map(cf -> new EligbleFieldResponse(cf.getId(), cf.getName(), this.cfTypeCheckerService.isSingleUserCustomField(cf))).collect(Collectors.toList());
        return Either.right((Object)new ApprovalCreateResponse(eligibleFields));
    }

    public Either<AnError, Integer> createApproval(ApplicationUser user, String issueKey, CreateApprovalRequest createApprovalRequest) {
        Either<ErrorCollection, Issue> issueEither = this.getIssueForApprover(user, issueKey);
        if (issueEither.isLeft()) {
            return Either.left((Object)this.approvalError.ISSUE_NOT_FOUND());
        }
        Issue issue = (Issue)issueEither.right().get();
        return Steps.begin(this.toCreateApprovalInput(issue, createApprovalRequest)).then(createInput -> this.approvalService.createApproval(user, createInput)).yield((createInput, approval) -> approval.getId());
    }

    public Either<AnError, List<ApprovalResponse>> getActiveApprovalForCurrentUser(ApplicationUser user, String issueKey) {
        Either<ErrorCollection, Issue> issueEither = this.getIssueForApprover(user, issueKey);
        if (issueEither.isLeft()) {
            return Either.left((Object)this.approvalError.ISSUE_NOT_FOUND());
        }
        Issue issue = (Issue)issueEither.right().get();
        return (Either)this.approverService.getActiveApprovalsForUser(issue, user).fold(Either::left, approvals -> Either.right(this.toResponses((Collection<Approval>)approvals)));
    }

    public Either<AnError, Boolean> checkActiveApproval(ApplicationUser user, String issueKey) {
        Either<ErrorCollection, Issue> issueEither = this.getIssueForApprover(user, issueKey);
        if (issueEither.isLeft()) {
            return Either.left((Object)this.approvalError.ISSUE_NOT_FOUND());
        }
        Issue issue = (Issue)issueEither.right().get();
        return Either.right((Object)this.approvalService.hasActiveApprovals(issue));
    }

    public Either<AnError, ApproverDecisionCollectionResponse> getApproversDecisions(ApplicationUser user, int approvalId) {
        return Steps.begin((Either)this.approvalService.getApprovalById(user, approvalId)).yield(approval -> this.toApproverDecisionCollectionResponse(this.approverDecisionService.getApproversDecisions(approval)));
    }

    public Either<AnError, ApprovalResponse> approveApproval(ApplicationUser user, Integer approvalId) {
        return this.createApproverDecision(user, approvalId, ApprovalDecisionType.APPROVED);
    }

    public Either<AnError, ApprovalResponse> rejectApproval(ApplicationUser user, Integer approvalId) {
        return this.createApproverDecision(user, approvalId, ApprovalDecisionType.REJECTED);
    }

    public Either<AnError, ApprovalResponse> createApproverDecision(ApplicationUser approver, int approvalId, ApprovalDecisionType decision) {
        return Steps.begin(this.toDecisionParam(approver, approvalId, decision)).then(decisionParams -> this.approverDecisionService.createApproverDecision(approver, decisionParams)).then((decisionParams, approverDecision) -> this.approvalService.getApprovalById(approver, approvalId)).yield((decisionParams, approverDecision, approval) -> this.toApprovalResponse((Approval)approval));
    }

    private Either<ErrorCollection, Issue> getIssueForApprover(ApplicationUser approver, String issueKey) {
        IssueService.IssueResult issueResult = this.issueService.getIssue(approver, issueKey);
        if (!issueResult.isValid()) {
            return Either.left((Object)issueResult.getErrorCollection());
        }
        return Either.right((Object)issueResult.getIssue());
    }

    private Either<AnError, CreateApprovalParameters> toCreateApprovalInput(Issue issue, CreateApprovalRequest createRequest) {
        Either<AnError, Collection<ApproverConfigurationDataInput>> configurationInputs = this.getApproverConfigurationInput(createRequest);
        if (configurationInputs.isLeft()) {
            return Either.left((Object)configurationInputs.left().get());
        }
        CreateApprovalParameters createApprovalParameters = this.approvalService.newCreateBuilder().issue(issue).name(createRequest.getName()).statusId(createRequest.getStatusId()).configurationInputs((Collection)configurationInputs.right().get()).approveCondition((ApprovalCondition)new ApprovalConditionImpl(createRequest.getApprovalCondition().getConditionType(), createRequest.getApprovalCondition().getConditionValue())).build();
        return Either.right((Object)createApprovalParameters);
    }

    private Either<AnError, Collection<ApproverConfigurationDataInput>> getApproverConfigurationInput(CreateApprovalRequest createRequest) {
        ArrayList configurationInputs = new ArrayList();
        ApproverRequest approverRequest = createRequest.getApprovers();
        Option<List<String>> usersApproversOpt = approverRequest.getUsers();
        if (usersApproversOpt.isDefined() && !((List)usersApproversOpt.get()).isEmpty()) {
            Either<AnError, Collection<ApproverConfigurationDataInput>> userDataInputEither = this.userApproverTypeConfigurationHandler.toDataInput((Collection)usersApproversOpt.get());
            if (userDataInputEither.isLeft()) {
                return Either.left((Object)userDataInputEither.left().get());
            }
            configurationInputs.addAll((Collection)userDataInputEither.right().get());
        }
        if (approverRequest.getCustomField().isDefined()) {
            Either<AnError, Collection<ApproverConfigurationDataInput>> customFieldDataInputEither = this.customFieldApproverTypeConfigurationHandler.toDataInput((String)approverRequest.getCustomField().get());
            if (customFieldDataInputEither.isLeft()) {
                return Either.left((Object)customFieldDataInputEither.left().get());
            }
            configurationInputs.addAll((Collection)customFieldDataInputEither.right().get());
        }
        return Either.right(configurationInputs);
    }

    private Either<AnError, ApproverDecisionParameters> toDecisionParam(ApplicationUser user, int approvalId, ApprovalDecisionType decision) {
        Either approvalEith = this.approvalService.getApprovalById(user, approvalId);
        if (approvalEith.isLeft()) {
            return Either.left((Object)approvalEith.left().get());
        }
        Approval approval = (Approval)approvalEith.right().get();
        ApproverDecisionParameters.Builder decisionParamsBuilder = this.approverDecisionService.newDecisionBuilder();
        decisionParamsBuilder.approval(approval).approver(user).approvalDecision(decision);
        return Either.right((Object)decisionParamsBuilder.build());
    }

    private ApprovalResponse toApprovalResponse(Approval approval) {
        ApprovalImpl approvalImpl = (ApprovalImpl)approval;
        return new ApprovalResponse(approvalImpl);
    }

    private ApproverDecisionCollectionResponse toApproverDecisionCollectionResponse(Collection<ApproverDecision> decisions) {
        List<ApproverDecisionResponse> decisionsList = decisions.stream().map(this::toApproverDecisionResponse).collect(Collectors.toList());
        return new ApproverDecisionCollectionResponse(decisionsList);
    }

    private ApproverDecisionResponse toApproverDecisionResponse(ApproverDecision decision) {
        return new ApproverDecisionResponse(decision.getDecision().name(), decision.getUserKey());
    }

    private List<ApprovalResponse> toResponses(Collection<Approval> approvals) {
        return approvals.stream().map(this::toApprovalResponse).collect(Collectors.toList());
    }
}

