/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.approvals.internal.requirement;

import com.atlassian.servicedesk.api.approval.Approval;
import com.atlassian.servicedesk.internal.api.requirement.ApprovalConditionType;
import com.atlassian.servicedesk.internal.api.requirement.UserCountApprovalRequirement;
import java.util.Set;

public class UserCountApprovalRequirementImpl
implements UserCountApprovalRequirement {
    private static final int DEFAULT_REQUIRED_USER_COUNT = 1;
    private int requiredUserCount;

    public UserCountApprovalRequirementImpl(String requiredUserCountString) {
        try {
            this.requiredUserCount = Integer.valueOf(requiredUserCountString);
        }
        catch (NumberFormatException ex) {
            this.requiredUserCount = 1;
        }
        if (this.requiredUserCount < 1) {
            throw new IllegalArgumentException("requiredUserCount must be positive");
        }
    }

    public int getRequiredUserCount() {
        return this.requiredUserCount;
    }

    public String getType() {
        return ApprovalConditionType.NUMBER.value();
    }

    public boolean isRequirementMet(Approval approval, Set<String> approvers, Set<String> votedApprovers) {
        return this.getRemainingVoteCount(approval, approvers, votedApprovers) == 0;
    }

    public int getRemainingVoteCount(Approval approval, Set<String> approvers, Set<String> votedApprovers) {
        int currentVoteCount = votedApprovers.size();
        int currentRequirement = this.getRequiredUserCount() - currentVoteCount;
        return currentRequirement < 0 ? 0 : currentRequirement;
    }
}

