/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.approvals.internal.requirement;

import com.atlassian.servicedesk.api.approval.Approval;
import com.atlassian.servicedesk.internal.api.requirement.ApprovalConditionType;
import com.atlassian.servicedesk.internal.api.requirement.PercentApprovalRequirement;
import com.atlassian.servicedesk.plugins.approvals.internal.approver.ApproverManager;
import java.util.HashSet;
import java.util.Set;

public class PercentApprovalRequirementImpl
implements PercentApprovalRequirement {
    private static final int DEFAULT_PERCENT = 100;
    private final ApproverManager approverManager;
    private int percent;

    public PercentApprovalRequirementImpl(ApproverManager approverManager, String percentString) {
        this.approverManager = approverManager;
        try {
            this.percent = Integer.valueOf(percentString);
        }
        catch (NumberFormatException ex) {
            this.percent = 100;
        }
        if (this.percent < 1 || 100 < this.percent) {
            throw new IllegalArgumentException("Percent needs to be between 1 and 100.");
        }
    }

    public int getPercent() {
        return this.percent;
    }

    public String getType() {
        return ApprovalConditionType.PERCENT.value();
    }

    public boolean isRequirementMet(Approval approval, Set<String> approvers, Set<String> existingVotes) {
        return this.getRemainingVoteCount(approval, approvers, existingVotes) == 0;
    }

    public int getRemainingVoteCount(Approval approval, Set<String> approvers, Set<String> votedApprovers) {
        int existingVoteCount;
        int requiredVoteCount = this.getRequiredVoteCount(approvers, votedApprovers);
        int remainingVoteCount = requiredVoteCount - (existingVoteCount = votedApprovers.size());
        return remainingVoteCount < 0 ? 0 : remainingVoteCount;
    }

    private int getRequiredVoteCount(Set<String> approversInCustomField, Set<String> votedApprovers) {
        int totalRequiredVoteCount = this.getTotalRequiredVoteCount(approversInCustomField, votedApprovers);
        float requiredVoteCountPercentage = (float)(totalRequiredVoteCount * this.getPercent()) / 100.0f;
        int requiredVoteCount = (int)Math.ceil(requiredVoteCountPercentage);
        return requiredVoteCount < 1 ? 1 : requiredVoteCount;
    }

    private int getTotalRequiredVoteCount(Set<String> approversInCustomField, Set<String> votedApprovers) {
        HashSet<String> totalRequiredVotes = new HashSet<String>(votedApprovers);
        totalRequiredVotes.addAll(approversInCustomField);
        return totalRequiredVotes.size();
    }
}

