/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.approvals.internal.requirement;

import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.servicedesk.api.approval.Approval;
import com.atlassian.servicedesk.api.approval.ApprovalDecisionType;
import com.atlassian.servicedesk.internal.api.requirement.ApprovalCondition;
import com.atlassian.servicedesk.internal.api.requirement.ApprovalConditionType;
import com.atlassian.servicedesk.internal.api.requirement.ApprovalRequirement;
import com.atlassian.servicedesk.internal.api.requirement.ApprovalRequirementService;
import com.atlassian.servicedesk.plugins.approvals.internal.approval.ApprovalImpl;
import com.atlassian.servicedesk.plugins.approvals.internal.approver.ApproverManager;
import com.atlassian.servicedesk.plugins.approvals.internal.decision.ApproverDecisionManager;
import com.atlassian.servicedesk.plugins.approvals.internal.requirement.PercentApprovalRequirementImpl;
import com.atlassian.servicedesk.plugins.approvals.internal.requirement.UserCountApprovalRequirementImpl;
import io.atlassian.fugue.Option;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ApprovalRequirementServiceImpl
implements ApprovalRequirementService {
    private final ApproverDecisionManager approverDecisionManager;
    private final ApproverManager approverManager;
    private UserCountApprovalRequirementImpl APPROVAL_REJECT_REQUIREMENT = new UserCountApprovalRequirementImpl("1");

    @Autowired
    public ApprovalRequirementServiceImpl(@Nonnull ApproverDecisionManager approverDecisionManager, @Nonnull ApproverManager approverManager) {
        this.approverDecisionManager = approverDecisionManager;
        this.approverManager = approverManager;
    }

    public Option<ApprovalDecisionType> calculateDecision(ApplicationUser user, Approval approval) {
        if (this.isRejected(approval)) {
            return Option.option((Object)ApprovalDecisionType.REJECTED);
        }
        if (this.isApproved(approval)) {
            return Option.option((Object)ApprovalDecisionType.APPROVED);
        }
        return Option.none();
    }

    public Option<Integer> getRemainingApproveDecisionsUntilApproved(ApplicationUser user, Approval approval) {
        if (approval.getDecision().isDefined()) {
            return Option.none();
        }
        int pendingCount = this.getApproveRequirement(approval).getRemainingVoteCount(approval, this.getApprovers(approval), this.getApprovedUserKeys(approval));
        return Option.some((Object)pendingCount);
    }

    public ApprovalCondition getApprovedCondition(Approval approval) {
        ApprovalImpl approvalImpl = (ApprovalImpl)approval;
        return approvalImpl.getApprovalCondition();
    }

    private boolean isApproved(Approval approval) {
        return this.getApproveRequirement(approval).isRequirementMet(approval, this.getApprovers(approval), this.getApprovedUserKeys(approval));
    }

    private ApprovalRequirement getApproveRequirement(Approval approval) {
        ApprovalImpl approvalImpl = (ApprovalImpl)approval;
        ApprovalCondition condition = approvalImpl.getApprovalCondition();
        if (condition.getConditionType().equals(ApprovalConditionType.PERCENT.value())) {
            return new PercentApprovalRequirementImpl(this.approverManager, condition.getConditionValue());
        }
        return new UserCountApprovalRequirementImpl(condition.getConditionValue());
    }

    private boolean isRejected(Approval approval) {
        return this.getRejectRequirement(approval).isRequirementMet(approval, this.getApprovers(approval), this.getDeclinedUserKeys(approval));
    }

    private Set<String> getApprovedUserKeys(Approval approval) {
        return this.approverDecisionManager.getApprovedUserKeys(approval);
    }

    private Set<String> getDeclinedUserKeys(Approval approval) {
        return this.approverDecisionManager.getDeclinedUserKeys(approval);
    }

    private Set<String> getApprovers(Approval approval) {
        return this.approverManager.getApprovers(approval).stream().map(approver -> approver.getKey()).collect(Collectors.toSet());
    }

    private ApprovalRequirement getRejectRequirement(Approval approval) {
        return this.APPROVAL_REJECT_REQUIREMENT;
    }
}

