/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.approvals.internal.permission;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.api.user.UserFactory;
import com.atlassian.servicedesk.internal.spi.permission.security.CustomerInvolvedType;
import com.atlassian.servicedesk.internal.spi.permission.security.RequestAccessUserStrategy;
import com.atlassian.servicedesk.plugins.approvals.internal.approver.ApproverManager;
import com.atlassian.servicedesk.plugins.approvals.internal.decision.ApproverDecisionManager;
import io.atlassian.fugue.Either;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ApproverRequestAccessUserStrategy
implements RequestAccessUserStrategy {
    private final ApproverManager approverManager;
    private final ApproverDecisionManager decisionManager;
    private final UserFactory userFactory;

    @Autowired
    public ApproverRequestAccessUserStrategy(ApproverManager approverManager, ApproverDecisionManager decisionManager, UserFactory userFactory) {
        this.approverManager = approverManager;
        this.decisionManager = decisionManager;
        this.userFactory = userFactory;
    }

    public List<CheckedUser> getUsers(@Nonnull Issue issue) {
        return this.approverManager.getApprovers(issue).stream().map(arg_0 -> ((UserFactory)this.userFactory).wrap(arg_0)).map(StepsConverters::newerEither).filter(Either::isRight).map(wrappedUser -> (CheckedUser)wrappedUser.right().get()).collect(Collectors.toList());
    }

    public CustomerInvolvedType getType() {
        return CustomerInvolvedType.APPROVER;
    }

    public boolean match(ApplicationUser user, Issue issue) {
        return this.isApproverOfIssue(user, issue) || this.hasUserMadeAnyDecisionOnIssue(user, issue);
    }

    private boolean isApproverOfIssue(ApplicationUser user, Issue issue) {
        return this.approverManager.isApprover(user, issue);
    }

    private boolean hasUserMadeAnyDecisionOnIssue(ApplicationUser user, Issue issue) {
        return this.decisionManager.hasUserMadeAnyDecisionOnIssue(user, issue);
    }
}

