/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.approvals.internal.notificationrecord;

import com.atlassian.pocketknife.api.querydsl.DatabaseAccessor;
import com.atlassian.pocketknife.api.querydsl.DatabaseConnection;
import com.atlassian.servicedesk.api.approval.Approval;
import com.atlassian.servicedesk.plugins.approvals.internal.approver.ApproverManager;
import com.atlassian.servicedesk.plugins.approvals.internal.dao.ApprovalNotificationRecordDao;
import com.atlassian.servicedesk.plugins.approvals.internal.notificationrecord.ApprovalNotificationRecord;
import com.atlassian.servicedesk.plugins.approvals.internal.notificationrecord.ApprovalNotificationRecordCreateParameters;
import com.atlassian.servicedesk.plugins.approvals.internal.notificationrecord.ApprovalNotificationRecordManager;
import java.util.Collection;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ApprovalNotificationRecordManagerImpl
implements ApprovalNotificationRecordManager {
    private final ApproverManager approverManager;
    private final DatabaseAccessor databaseAccessor;
    private final ApprovalNotificationRecordDao approvalNotificationRecordDao;

    @Autowired
    public ApprovalNotificationRecordManagerImpl(ApproverManager approverManager, DatabaseAccessor databaseAccessor, ApprovalNotificationRecordDao approvalNotificationRecordDao) {
        this.approverManager = approverManager;
        this.databaseAccessor = databaseAccessor;
        this.approvalNotificationRecordDao = approvalNotificationRecordDao;
    }

    @Override
    public ApprovalNotificationRecord createApprovalNotificationRecord(ApprovalNotificationRecordCreateParameters createParameters) {
        return (ApprovalNotificationRecord)this.databaseAccessor.runInTransaction(databaseConnection -> this.approvalNotificationRecordDao.createNotificationRecord(createParameters, (DatabaseConnection)databaseConnection));
    }

    @Override
    public Collection<ApprovalNotificationRecord> getNotificationRecordByApproval(Approval approval) {
        return (Collection)this.databaseAccessor.runInTransaction(databaseConnection -> this.approvalNotificationRecordDao.getNotificationRecordByApproval(approval, (DatabaseConnection)databaseConnection));
    }

    @Override
    public long createBulkNotificationRecords(Collection<ApprovalNotificationRecordCreateParameters> createParameterses) {
        return (Long)this.databaseAccessor.runInTransaction(databaseConnection -> this.approvalNotificationRecordDao.createBulkNotificationRecords(createParameterses, (DatabaseConnection)databaseConnection));
    }
}

