/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.approvals.internal.notification;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.servicedesk.internal.api.events.ApprovalRequestedEvent;
import io.atlassian.fugue.Option;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public class ApprovalRequestedEventImpl
implements ApprovalRequestedEvent {
    private final long issueId;
    private final Set<String> approverUserKeys;
    private final Option<ApplicationUser> initiator;
    private final Date eventTime;

    ApprovalRequestedEventImpl(Option<ApplicationUser> user, Issue issue, Collection<ApplicationUser> approvers, Date eventTime) {
        this.initiator = user;
        this.issueId = issue.getId();
        this.approverUserKeys = Collections.unmodifiableSet(approvers.stream().map(ApplicationUser::getKey).collect(Collectors.toSet()));
        this.eventTime = eventTime;
    }

    public Option<ApplicationUser> getInitiator() {
        return this.initiator;
    }

    public long getIssueId() {
        return this.issueId;
    }

    @Nonnull
    public Set<String> getApproverUserKeys() {
        return this.approverUserKeys;
    }

    public Date getTime() {
        return this.eventTime;
    }
}

