/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.approvals.internal.events;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.servicedesk.api.approval.Approval;
import com.atlassian.servicedesk.plugins.approvals.internal.approver.ApproverManager;
import com.atlassian.servicedesk.plugins.approvals.internal.events.ApprovalCompletedEvent;
import com.atlassian.servicedesk.plugins.approvals.internal.events.ApprovalCreatedEvent;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ApprovalEventDispatcher {
    private static final Logger logger = LoggerFactory.getLogger(ApprovalEventDispatcher.class);
    private final EventPublisher eventPublisher;
    private final ApproverManager approverManager;

    @Autowired
    public ApprovalEventDispatcher(EventPublisher eventPublisher, ApproverManager approverManager) {
        this.eventPublisher = eventPublisher;
        this.approverManager = approverManager;
    }

    public void dispatchApprovalDecisionEvent(Approval approval, ApplicationUser user) {
        if (approval.getDecision().isDefined()) {
            this.eventPublisher.publish((Object)new ApprovalCompletedEvent(approval, user));
        }
    }

    public void dispatchCreatedApprovalEvent(Approval approval, ApplicationUser user) {
        Collection<ApplicationUser> approvers = this.approverManager.getApprovers(approval);
        this.eventPublisher.publish((Object)new ApprovalCreatedEvent(approval, user, (Set<ApplicationUser>)ImmutableSet.copyOf(approvers)));
    }
}

