/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.approvals.internal.dao;

import com.atlassian.fugue.Option;
import com.atlassian.jira.issue.Issue;
import com.atlassian.pocketknife.api.querydsl.DatabaseConnection;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.api.approval.Approval;
import com.atlassian.servicedesk.api.approval.ApprovalDecisionType;
import com.atlassian.servicedesk.internal.api.approver.ApproverConfigurationType;
import com.atlassian.servicedesk.internal.api.decision.ApproverDecision;
import com.atlassian.servicedesk.plugins.approvals.internal.approval.ApprovalImpl;
import com.atlassian.servicedesk.plugins.approvals.internal.approver.ApproverConfigurationData;
import com.atlassian.servicedesk.plugins.approvals.internal.dao.ApprovalData;
import com.atlassian.servicedesk.plugins.approvals.internal.dao.IssueApprovalData;
import com.atlassian.servicedesk.plugins.approvals.internal.dao.IssueApprovalDataDao;
import com.atlassian.servicedesk.plugins.approvals.internal.dao.schema.querydsl.mapping.Tables;
import com.atlassian.servicedesk.plugins.approvals.internal.decision.ApproverDecisionImpl;
import com.atlassian.servicedesk.plugins.approvals.internal.requirement.ApprovalConditionImpl;
import com.google.common.collect.Lists;
import com.querydsl.core.Tuple;
import com.querydsl.core.group.Group;
import com.querydsl.core.group.GroupBy;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.sql.SQLQuery;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.stereotype.Component;

@Component
public class IssueApprovalDataDaoImpl
implements IssueApprovalDataDao {
    @Override
    public IssueApprovalData getApprovalIndexDbData(Issue issue, DatabaseConnection databaseConnection) {
        Map rawTransform = (Map)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)databaseConnection.query().from((Expression)Tables.APPROVAL)).leftJoin((EntityPath)Tables.APPROVER)).on((Predicate)Tables.APPROVAL.ID.eq(Tables.APPROVER.APPROVAL_ID))).leftJoin((EntityPath)Tables.APPROVER_DECISION)).on((Predicate)Tables.APPROVAL.ID.eq(Tables.APPROVER_DECISION.APPROVAL_ID))).where((Predicate)Tables.APPROVAL.ISSUE_ID.eq((Object)issue.getId()))).transform(GroupBy.groupBy(Tables.APPROVAL.ID).as(new Expression[]{Projections.tuple((Expression[])Tables.APPROVAL.all()), GroupBy.set((Expression)Projections.tuple((Expression[])Tables.APPROVER.all())), GroupBy.set((Expression)Projections.tuple((Expression[])Tables.APPROVER_DECISION.all()))}));
        Collection<ApprovalData> approvalDatas = this.transformToIndexDbDatas(rawTransform);
        return new IssueApprovalData(issue, approvalDatas);
    }

    private Collection<ApprovalData> transformToIndexDbDatas(Map<Integer, Group> rawTransforms) {
        ArrayList dbDatas = Lists.newArrayList();
        for (Map.Entry<Integer, Group> entry : rawTransforms.entrySet()) {
            Group group = entry.getValue();
            dbDatas.add(this.transformToIndexDbData(group));
        }
        return dbDatas;
    }

    private ApprovalData transformToIndexDbData(Group group) {
        Tuple approvalTuple = (Tuple)group.getOne((Expression)Projections.tuple((Expression[])Tables.APPROVAL.all()));
        Approval approval = this.transfromToApproval(approvalTuple);
        Set approverTuples = group.getSet((Expression)Projections.tuple((Expression[])Tables.APPROVER.all()));
        Set<ApproverConfigurationData> configurationDatas = this.transformToApproverConfigurationDatas(approverTuples);
        Set decisionTuples = group.getSet((Expression)Projections.tuple((Expression[])Tables.APPROVER_DECISION.all()));
        Set<ApproverDecision> approverDecisions = this.transformToApproverDecision(decisionTuples);
        return new ApprovalData(approval, configurationDatas, approverDecisions);
    }

    private Approval transfromToApproval(Tuple tuple) {
        return new ApprovalImpl((Integer)tuple.get(Tables.APPROVAL.ID), (Long)tuple.get(Tables.APPROVAL.ISSUE_ID), (String)tuple.get((Expression)Tables.APPROVAL.NAME), new ApprovalConditionImpl((String)tuple.get((Expression)Tables.APPROVAL.APPROVE_CONDITION_TYPE), (String)tuple.get((Expression)Tables.APPROVAL.APPROVE_CONDITION_VALUE)), (Option<ApprovalDecisionType>)StepsConverters.olderOption((io.atlassian.fugue.Option)io.atlassian.fugue.Option.option((Object)tuple.get((Expression)Tables.APPROVAL.DECISION)).map(ApprovalDecisionType::forKey)), Instant.ofEpochMilli((Long)tuple.get(Tables.APPROVAL.CREATED_DATE)), (Option<Instant>)StepsConverters.olderOption((io.atlassian.fugue.Option)io.atlassian.fugue.Option.option((Object)tuple.get(Tables.APPROVAL.COMPLETED_DATE)).map(Instant::ofEpochMilli)), (String)tuple.get((Expression)Tables.APPROVAL.STATUS_ID));
    }

    private Set<ApproverConfigurationData> transformToApproverConfigurationDatas(Set<Tuple> tuples) {
        return tuples.stream().map(tuple -> this.toApproverConfigurationData((Tuple)tuple)).filter(data -> data.isDefined()).map(dataOpt -> (ApproverConfigurationData)dataOpt.get()).collect(Collectors.toSet());
    }

    private Set<ApproverDecision> transformToApproverDecision(Set<Tuple> tuples) {
        return tuples.stream().map(tuple -> this.toApproverDecisionRecord((Tuple)tuple)).filter(decision -> decision.isDefined()).map(dataOpt -> (ApproverDecision)dataOpt.get()).collect(Collectors.toSet());
    }

    private io.atlassian.fugue.Option<ApproverConfigurationData> toApproverConfigurationData(Tuple tuple) {
        Integer id = (Integer)tuple.get(Tables.APPROVER.ID);
        if (id == null) {
            return io.atlassian.fugue.Option.none();
        }
        int approvalId = (Integer)tuple.get(Tables.APPROVER.APPROVAL_ID);
        ApproverConfigurationType configurationType = ApproverConfigurationType.forKey((String)((String)tuple.get((Expression)Tables.APPROVER.TYPE)));
        String approverValue = (String)tuple.get((Expression)Tables.APPROVER.VALUE);
        return io.atlassian.fugue.Option.some((Object)new ApproverConfigurationData(approvalId, configurationType, approverValue));
    }

    private io.atlassian.fugue.Option<ApproverDecision> toApproverDecisionRecord(Tuple tuple) {
        Integer id = (Integer)tuple.get(Tables.APPROVER_DECISION.ID);
        if (id == null) {
            return io.atlassian.fugue.Option.none();
        }
        String decision = (String)tuple.get((Expression)Tables.APPROVER_DECISION.DECISION);
        String userKey = (String)tuple.get((Expression)Tables.APPROVER_DECISION.USER_KEY);
        Instant decisionDate = Instant.ofEpochMilli((Long)tuple.get(Tables.APPROVER_DECISION.SENT_DATE));
        return io.atlassian.fugue.Option.some((Object)new ApproverDecisionImpl(id, ApprovalDecisionType.forKey((String)decision), userKey, decisionDate));
    }
}

