/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.approvals.internal.dao;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.pocketknife.api.querydsl.DatabaseConnection;
import com.atlassian.servicedesk.api.approval.Approval;
import com.atlassian.servicedesk.api.approval.ApprovalDecisionType;
import com.atlassian.servicedesk.internal.api.decision.ApproverDecision;
import com.atlassian.servicedesk.internal.api.decision.ApproverDecisionParameters;
import com.atlassian.servicedesk.plugins.approvals.internal.dao.ApproverDecisionDao;
import com.atlassian.servicedesk.plugins.approvals.internal.dao.schema.querydsl.mapping.Tables;
import com.atlassian.servicedesk.plugins.approvals.internal.decision.ApproverDecisionImpl;
import com.atlassian.servicedesk.plugins.approvals.internal.decision.ApproverDecisionParametersImpl;
import com.atlassian.servicedesk.plugins.approvals.internal.util.ApprovalDecisionTypeValueHelper;
import com.querydsl.core.Tuple;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLQuery;
import io.atlassian.fugue.Option;
import java.time.Instant;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.joda.time.DateTimeUtils;
import org.springframework.stereotype.Component;

@Component
public class ApproverDecisionDaoImpl
implements ApproverDecisionDao {
    @Override
    public ApproverDecision create(ApproverDecisionParameters decisionParameters, DatabaseConnection databaseConnection) {
        try {
            ApproverDecisionParametersImpl params = (ApproverDecisionParametersImpl)decisionParameters;
            Integer key = (Integer)databaseConnection.insert((RelationalPath)Tables.APPROVER_DECISION).set(Tables.APPROVER_DECISION.APPROVAL_ID, (Object)params.getApproval().getId()).set(Tables.APPROVER_DECISION.SENT_DATE, (Object)DateTimeUtils.currentTimeMillis()).set((Path)Tables.APPROVER_DECISION.USER_KEY, (Object)params.getApprover().getKey()).set((Path)Tables.APPROVER_DECISION.DECISION, (Object)ApprovalDecisionTypeValueHelper.toDatabaseValue(params.getDecision())).executeWithKey(Tables.APPROVER_DECISION.ID);
            return (ApproverDecision)this.getById(key, databaseConnection).get();
        }
        catch (RuntimeException ex) {
            throw new RuntimeException("Failed to create ApproverDecisionDao", ex);
        }
    }

    @Override
    public boolean hasApproverMadeDecision(Approval approval, ApplicationUser approver, DatabaseConnection databaseConnection) {
        try {
            Long count = ((SQLQuery)((SQLQuery)databaseConnection.select(Tables.APPROVER_DECISION.ID).from((Expression)Tables.APPROVER_DECISION)).where((Predicate)Tables.APPROVER_DECISION.APPROVAL_ID.eq((Object)approval.getId()).and((Predicate)Tables.APPROVER_DECISION.USER_KEY.eq((Object)approver.getKey())))).fetchCount();
            return count > 0L;
        }
        catch (RuntimeException ex) {
            throw new RuntimeException("Failed to check if user has made decision", ex);
        }
    }

    @Override
    public Set<String> getApprovedUserKeys(Approval approval, DatabaseConnection databaseConnection) {
        return this.getMadeDecisionUsersKey(approval, ApprovalDecisionType.APPROVED, databaseConnection);
    }

    @Override
    public Set<String> getDeclinedUserKeys(Approval approval, DatabaseConnection databaseConnection) {
        return this.getMadeDecisionUsersKey(approval, ApprovalDecisionType.REJECTED, databaseConnection);
    }

    private Set<String> getMadeDecisionUsersKey(Approval approval, ApprovalDecisionType decision, DatabaseConnection databaseConnection) {
        try {
            List results = ((SQLQuery)((SQLQuery)databaseConnection.select((Expression)Tables.APPROVER_DECISION.USER_KEY).from((Expression)Tables.APPROVER_DECISION)).where((Predicate)Tables.APPROVER_DECISION.APPROVAL_ID.eq((Object)approval.getId()).and((Predicate)Tables.APPROVER_DECISION.DECISION.eq((Object)ApprovalDecisionTypeValueHelper.toDatabaseValue(decision))))).fetch();
            return new HashSet<String>(results);
        }
        catch (RuntimeException ex) {
            throw new RuntimeException("Failed to get made-decision user's keys", ex);
        }
    }

    @Override
    public Option<ApproverDecision> getById(int id, DatabaseConnection databaseConnection) {
        try {
            Tuple result = (Tuple)((SQLQuery)((SQLQuery)databaseConnection.select((Expression[])Tables.APPROVER_DECISION.all()).from((Expression)Tables.APPROVER_DECISION)).where((Predicate)Tables.APPROVER_DECISION.ID.eq((Object)id))).fetchFirst();
            if (result == null) {
                return Option.none();
            }
            return Option.some((Object)this.toApproverDecisionRecord(result));
        }
        catch (RuntimeException ex) {
            throw new RuntimeException("Failed to get ApproverDecision", ex);
        }
    }

    @Override
    public Collection<ApproverDecision> getApproverDecisions(Approval approval, DatabaseConnection databaseConnection) {
        try {
            List results = ((SQLQuery)((SQLQuery)databaseConnection.select(new Expression[]{Tables.APPROVER_DECISION.ID, Tables.APPROVER_DECISION.USER_KEY, Tables.APPROVER_DECISION.DECISION, Tables.APPROVER_DECISION.SENT_DATE}).from((Expression)Tables.APPROVER_DECISION)).where((Predicate)Tables.APPROVER_DECISION.APPROVAL_ID.eq((Object)approval.getId()))).fetch();
            return results.stream().map(result -> this.toApproverDecisionRecord((Tuple)result)).collect(Collectors.toList());
        }
        catch (RuntimeException ex) {
            throw new RuntimeException("Failed to get the list of approvers' decisions", ex);
        }
    }

    @Override
    public Collection<ApproverDecision> getApproverDecisionsBasedOnIssue(Issue issue, DatabaseConnection databaseConnection) {
        try {
            SQLQuery query = (SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)databaseConnection.select(new Expression[]{Tables.APPROVER_DECISION.ID, Tables.APPROVER_DECISION.USER_KEY, Tables.APPROVER_DECISION.DECISION, Tables.APPROVER_DECISION.SENT_DATE}).from((Expression)Tables.APPROVER_DECISION)).join((EntityPath)Tables.APPROVAL)).on((Predicate)Tables.APPROVER_DECISION.APPROVAL_ID.eq(Tables.APPROVAL.ID))).where((Predicate)Tables.APPROVAL.ISSUE_ID.eq((Object)issue.getId()));
            List results = query.fetch();
            return results.stream().map(result -> this.toApproverDecisionRecord((Tuple)result)).collect(Collectors.toList());
        }
        catch (RuntimeException ex) {
            throw new RuntimeException("Failed to get approver decisions based on issue", ex);
        }
    }

    @Override
    public Set<String> getUserKeyofApproversWhoMadeDecision(Issue issue, DatabaseConnection databaseConnection) {
        try {
            SQLQuery query = (SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)databaseConnection.select((Expression)Tables.APPROVER_DECISION.USER_KEY).from((Expression)Tables.APPROVER_DECISION)).join((EntityPath)Tables.APPROVAL)).on((Predicate)Tables.APPROVER_DECISION.APPROVAL_ID.eq(Tables.APPROVAL.ID))).where((Predicate)Tables.APPROVAL.ISSUE_ID.eq((Object)issue.getId()));
            List results = query.fetch();
            return new HashSet<String>(results);
        }
        catch (RuntimeException ex) {
            throw new RuntimeException("Failed to get count user decision on issue", ex);
        }
    }

    @Override
    public long getUserDecisionCountForIssue(ApplicationUser user, Issue issue, DatabaseConnection databaseConnection) {
        try {
            SQLQuery query = (SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)databaseConnection.select(Tables.APPROVER_DECISION.ID).from((Expression)Tables.APPROVER_DECISION)).join((EntityPath)Tables.APPROVAL)).on((Predicate)Tables.APPROVER_DECISION.APPROVAL_ID.eq(Tables.APPROVAL.ID))).where((Predicate)Tables.APPROVAL.ISSUE_ID.eq((Object)issue.getId()).and((Predicate)Tables.APPROVER_DECISION.USER_KEY.eq((Object)user.getKey())));
            return query.fetchCount();
        }
        catch (RuntimeException ex) {
            throw new RuntimeException("Failed to get count user decision on issue", ex);
        }
    }

    private ApproverDecision toApproverDecisionRecord(Tuple result) {
        int id = (Integer)result.get(Tables.APPROVER_DECISION.ID);
        String decision = (String)result.get((Expression)Tables.APPROVER_DECISION.DECISION);
        String userKey = (String)result.get((Expression)Tables.APPROVER_DECISION.USER_KEY);
        Instant decisionDate = Instant.ofEpochMilli((Long)result.get(Tables.APPROVER_DECISION.SENT_DATE));
        return new ApproverDecisionImpl(id, ApprovalDecisionType.forKey((String)decision), userKey, decisionDate);
    }
}

