/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.approvals.internal.dao;

import com.atlassian.pocketknife.api.querydsl.DatabaseConnection;
import com.atlassian.servicedesk.api.approval.Approval;
import com.atlassian.servicedesk.plugins.approvals.internal.dao.ApprovalNotificationRecordDao;
import com.atlassian.servicedesk.plugins.approvals.internal.dao.schema.querydsl.mapping.Tables;
import com.atlassian.servicedesk.plugins.approvals.internal.notificationrecord.ApprovalNotificationRecord;
import com.atlassian.servicedesk.plugins.approvals.internal.notificationrecord.ApprovalNotificationRecordCreateParameters;
import com.atlassian.servicedesk.plugins.approvals.internal.notificationrecord.ApprovalNotificationRecordImpl;
import com.querydsl.core.Tuple;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLQuery;
import com.querydsl.sql.dml.SQLInsertClause;
import io.atlassian.fugue.Option;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.joda.time.DateTimeUtils;
import org.springframework.stereotype.Component;

@Component
public class ApprovalNotificationRecordDaoImpl
implements ApprovalNotificationRecordDao {
    @Override
    public ApprovalNotificationRecord createNotificationRecord(ApprovalNotificationRecordCreateParameters createParameters, DatabaseConnection databaseConnection) {
        try {
            Integer id = (Integer)databaseConnection.insert((RelationalPath)Tables.NOTIFICATION_RECORD).set(Tables.NOTIFICATION_RECORD.APPROVAL_ID, (Object)createParameters.getApproval().getId()).set((Path)Tables.NOTIFICATION_RECORD.USER_KEY, (Object)createParameters.getUser().getKey()).set(Tables.NOTIFICATION_RECORD.SENT_DATE, (Object)DateTimeUtils.currentTimeMillis()).executeWithKey(Tables.NOTIFICATION_RECORD.ID);
            if (id == null) {
                throw new RuntimeException("Expected to create a ApprovalNotificationRecord but none is created");
            }
            Option<ApprovalNotificationRecord> notificationRecord = this.getById(id, databaseConnection);
            if (notificationRecord.isEmpty()) {
                throw new RuntimeException("Failed to get ApprovalNotificationRecord after creation");
            }
            return (ApprovalNotificationRecord)notificationRecord.get();
        }
        catch (RuntimeException ex) {
            throw new RuntimeException("Failed to create ApprovalNotificationRecord", ex);
        }
    }

    @Override
    public long createBulkNotificationRecords(Collection<ApprovalNotificationRecordCreateParameters> createParameters, DatabaseConnection databaseConnection) {
        try {
            if (createParameters.isEmpty()) {
                return 0L;
            }
            SQLInsertClause sqlBatchInsertClause = databaseConnection.insert((RelationalPath)Tables.NOTIFICATION_RECORD);
            createParameters.stream().forEach(param -> {
                sqlBatchInsertClause.set(Tables.NOTIFICATION_RECORD.APPROVAL_ID, (Object)param.getApproval().getId());
                sqlBatchInsertClause.set((Path)Tables.NOTIFICATION_RECORD.USER_KEY, (Object)param.getUser().getKey());
                sqlBatchInsertClause.set(Tables.NOTIFICATION_RECORD.SENT_DATE, (Object)DateTimeUtils.currentTimeMillis());
                sqlBatchInsertClause.addBatch();
            });
            long rowUpdateds = sqlBatchInsertClause.execute();
            if (rowUpdateds != (long)createParameters.size()) {
                throw new RuntimeException("Expected number of rows " + createParameters.size() + " to be updated does not match number of rows updated " + rowUpdateds);
            }
            return rowUpdateds;
        }
        catch (RuntimeException ex) {
            throw new RuntimeException("Failed to create bulk ApprovalNotificationRecord", ex);
        }
    }

    @Override
    public Collection<ApprovalNotificationRecord> getNotificationRecordByApproval(Approval approval, DatabaseConnection databaseConnection) {
        try {
            List tuples = ((SQLQuery)((SQLQuery)databaseConnection.select((Expression[])Tables.NOTIFICATION_RECORD.all()).from((Expression)Tables.NOTIFICATION_RECORD)).where((Predicate)Tables.NOTIFICATION_RECORD.APPROVAL_ID.eq((Object)approval.getId()))).fetch();
            return tuples.stream().map(tuple -> this.tuple2Record((Tuple)tuple)).collect(Collectors.toList());
        }
        catch (RuntimeException ex) {
            throw new RuntimeException("Failed to get ApprovalNotificationRecord by Approval", ex);
        }
    }

    private Option<ApprovalNotificationRecord> getById(int id, DatabaseConnection databaseConnection) {
        try {
            Tuple tuple = (Tuple)((SQLQuery)((SQLQuery)databaseConnection.select((Expression[])Tables.NOTIFICATION_RECORD.all()).from((Expression)Tables.NOTIFICATION_RECORD)).where((Predicate)Tables.NOTIFICATION_RECORD.ID.eq((Object)id))).fetchFirst();
            if (tuple == null) {
                return Option.none();
            }
            return Option.some((Object)this.tuple2Record(tuple));
        }
        catch (RuntimeException ex) {
            throw new RuntimeException("Failed to get ApprovalNotificationRecord for id=" + id, ex);
        }
    }

    private ApprovalNotificationRecord tuple2Record(Tuple tuple) {
        return new ApprovalNotificationRecordImpl((Integer)tuple.get(Tables.NOTIFICATION_RECORD.APPROVAL_ID), (String)tuple.get((Expression)Tables.NOTIFICATION_RECORD.USER_KEY), (Long)tuple.get(Tables.NOTIFICATION_RECORD.SENT_DATE));
    }
}

