/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.approvals.internal.dao;

import com.atlassian.fugue.Option;
import com.atlassian.jira.issue.Issue;
import com.atlassian.pocketknife.api.querydsl.DatabaseConnection;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.api.approval.Approval;
import com.atlassian.servicedesk.api.approval.ApprovalDecisionType;
import com.atlassian.servicedesk.internal.api.approval.CreateApprovalParameters;
import com.atlassian.servicedesk.plugins.approvals.internal.approval.ApprovalImpl;
import com.atlassian.servicedesk.plugins.approvals.internal.approval.CreateApprovalParametersImpl;
import com.atlassian.servicedesk.plugins.approvals.internal.dao.ApprovalDao;
import com.atlassian.servicedesk.plugins.approvals.internal.dao.schema.querydsl.mapping.Tables;
import com.atlassian.servicedesk.plugins.approvals.internal.requirement.ApprovalConditionImpl;
import com.atlassian.servicedesk.plugins.approvals.internal.util.ApprovalDecisionTypeValueHelper;
import com.querydsl.core.Tuple;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLQuery;
import java.time.Instant;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.stereotype.Component;

@Component
public class ApprovalDaoImpl
implements ApprovalDao {
    @Override
    public io.atlassian.fugue.Option<Approval> create(CreateApprovalParameters createApprovalParameters, DatabaseConnection databaseConnection) {
        try {
            CreateApprovalParametersImpl createInput = (CreateApprovalParametersImpl)createApprovalParameters;
            Integer id = (Integer)databaseConnection.insert((RelationalPath)Tables.APPROVAL).set(Tables.APPROVAL.ISSUE_ID, (Object)createInput.getIssue().getId()).set((Path)Tables.APPROVAL.NAME, (Object)createInput.getName()).set((Path)Tables.APPROVAL.APPROVE_CONDITION_TYPE, (Object)createInput.getApprovalCondition().getConditionType()).set((Path)Tables.APPROVAL.APPROVE_CONDITION_VALUE, (Object)createInput.getApprovalCondition().getConditionValue()).set(Tables.APPROVAL.CREATED_DATE, (Object)Instant.now().toEpochMilli()).set((Path)Tables.APPROVAL.STATUS_ID, (Object)createInput.getStatusId()).executeWithKey(Tables.APPROVAL.ID);
            if (id == null) {
                return io.atlassian.fugue.Option.none();
            }
            return this.getById(id, databaseConnection);
        }
        catch (RuntimeException ex) {
            throw new RuntimeException("Failed to create Approval", ex);
        }
    }

    @Override
    public io.atlassian.fugue.Option<Approval> setFinalDecision(Approval updatedApproval, ApprovalDecisionType decision, DatabaseConnection databaseConnection) {
        try {
            Long updatedRows = databaseConnection.update((RelationalPath)Tables.APPROVAL).set((Path)Tables.APPROVAL.DECISION, (Object)ApprovalDecisionTypeValueHelper.toDatabaseValue(decision)).set(Tables.APPROVAL.COMPLETED_DATE, (Object)Instant.now().toEpochMilli()).where((Predicate)Tables.APPROVAL.ID.eq((Object)updatedApproval.getId())).execute();
            if (updatedRows != 1L) {
                throw new RuntimeException(String.format("Expected %d row to be updated, but %d updated", 1, updatedRows));
            }
            return this.getById(updatedApproval.getId(), databaseConnection);
        }
        catch (RuntimeException ex) {
            throw new RuntimeException("Failed to update Approval for Id=" + updatedApproval.getId(), ex);
        }
    }

    @Override
    public void removeById(int id, DatabaseConnection databaseConnection) {
        try {
            Long deletedRows = databaseConnection.delete((RelationalPath)Tables.APPROVAL).where((Predicate)Tables.APPROVAL.ID.eq((Object)id)).execute();
            if (deletedRows != 1L) {
                throw new RuntimeException(String.format("Expected %d row to be removed, but %d removed", 1, deletedRows));
            }
        }
        catch (RuntimeException ex) {
            throw new RuntimeException("Failed to remove Approval for Id=" + id, ex);
        }
    }

    @Override
    public io.atlassian.fugue.Option<Approval> getById(int id, DatabaseConnection databaseConnection) {
        try {
            Tuple result = (Tuple)((SQLQuery)((SQLQuery)databaseConnection.select((Expression[])Tables.APPROVAL.all()).from((Expression)Tables.APPROVAL)).where((Predicate)Tables.APPROVAL.ID.eq((Object)id))).fetchFirst();
            if (result == null) {
                return io.atlassian.fugue.Option.none();
            }
            return io.atlassian.fugue.Option.option((Object)this.tuple2Approval(result));
        }
        catch (RuntimeException ex) {
            throw new RuntimeException("Failed to get Approval for Id=" + id, ex);
        }
    }

    @Override
    public Collection<Approval> getByIds(Collection<Integer> ids, DatabaseConnection databaseConnection) {
        try {
            List result = ((SQLQuery)((SQLQuery)databaseConnection.select((Expression[])Tables.APPROVAL.all()).from((Expression)Tables.APPROVAL)).where((Predicate)Tables.APPROVAL.ID.in(ids))).fetch();
            return result.stream().map(tuple -> this.tuple2Approval((Tuple)tuple)).collect(Collectors.toList());
        }
        catch (RuntimeException ex) {
            throw new RuntimeException("Failed to get Approval for Ids=" + ids, ex);
        }
    }

    @Override
    public Collection<Approval> getApprovalsByIssue(Issue issue, DatabaseConnection databaseConnection) {
        try {
            List results = ((SQLQuery)((SQLQuery)databaseConnection.select((Expression[])Tables.APPROVAL.all()).from((Expression)Tables.APPROVAL)).where((Predicate)Tables.APPROVAL.ISSUE_ID.eq((Object)issue.getId()))).fetch();
            return results.stream().map(tuple -> this.tuple2Approval((Tuple)tuple)).collect(Collectors.toList());
        }
        catch (RuntimeException ex) {
            throw new RuntimeException("Failed to get approval for Issue issueId=" + issue.getId(), ex);
        }
    }

    @Override
    public Collection<Approval> getActiveApprovals(Issue issue, DatabaseConnection databaseConnection) {
        try {
            List results = ((SQLQuery)((SQLQuery)databaseConnection.select((Expression[])Tables.APPROVAL.all()).from((Expression)Tables.APPROVAL)).where((Predicate)Tables.APPROVAL.ISSUE_ID.eq((Object)issue.getId()).and((Predicate)Tables.APPROVAL.DECISION.isNull()))).fetch();
            return results.stream().map(tuple -> this.tuple2Approval((Tuple)tuple)).collect(Collectors.toList());
        }
        catch (RuntimeException ex) {
            throw new RuntimeException("Failed to get active approval for issue=" + issue.getId(), ex);
        }
    }

    private Approval tuple2Approval(Tuple tuple) {
        return new ApprovalImpl((Integer)tuple.get(Tables.APPROVAL.ID), (Long)tuple.get(Tables.APPROVAL.ISSUE_ID), (String)tuple.get((Expression)Tables.APPROVAL.NAME), new ApprovalConditionImpl((String)tuple.get((Expression)Tables.APPROVAL.APPROVE_CONDITION_TYPE), (String)tuple.get((Expression)Tables.APPROVAL.APPROVE_CONDITION_VALUE)), (Option<ApprovalDecisionType>)StepsConverters.olderOption((io.atlassian.fugue.Option)io.atlassian.fugue.Option.option((Object)tuple.get((Expression)Tables.APPROVAL.DECISION)).map(ApprovalDecisionType::forKey)), Instant.ofEpochMilli((Long)tuple.get(Tables.APPROVAL.CREATED_DATE)), (Option<Instant>)StepsConverters.olderOption((io.atlassian.fugue.Option)io.atlassian.fugue.Option.option((Object)tuple.get(Tables.APPROVAL.COMPLETED_DATE)).map(Instant::ofEpochMilli)), (String)tuple.get((Expression)Tables.APPROVAL.STATUS_ID));
    }
}

