/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.approvals.internal.customfield;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.customfields.impl.CalculatedCFType;
import com.atlassian.jira.issue.customfields.impl.FieldValidationException;
import com.atlassian.jira.issue.customfields.view.CustomFieldParams;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.servicedesk.internal.api.approval.InternalApprovalService;
import com.atlassian.servicedesk.plugins.approvals.internal.customfield.ApprovalsCFValue;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import io.atlassian.fugue.Either;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ApprovalsCFType
extends CalculatedCFType<ApprovalsCFValue, ApprovalsCFValue> {
    private final InternalApprovalService approvalService;
    private final JiraAuthenticationContext authenticationContext;

    public ApprovalsCFType(@Nonnull InternalApprovalService approvalService, @Nonnull JiraAuthenticationContext authenticationContext) {
        this.approvalService = approvalService;
        this.authenticationContext = authenticationContext;
    }

    public String getStringFromSingularObject(ApprovalsCFValue singularObject) {
        return "";
    }

    public ApprovalsCFValue getSingularObjectFromString(String string) throws FieldValidationException {
        return new ApprovalsCFValue(Lists.newArrayList());
    }

    public ApprovalsCFValue getValueFromCustomFieldParams(CustomFieldParams parameters) throws FieldValidationException {
        return null;
    }

    @Nullable
    public ApprovalsCFValue getValueFromIssue(CustomField field, Issue issue) {
        ApplicationUser user = this.authenticationContext.getLoggedInUser();
        if (issue != null && user != null) {
            Either approvalsEith = this.approvalService.getApprovals(user, issue);
            Collection approvals = (Collection)approvalsEith.getOrElse((Object)Sets.newHashSet());
            return new ApprovalsCFValue(approvals);
        }
        return null;
    }
}

