/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.approvals.internal.customfield;

import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.pocketknife.api.customfields.service.CustomFieldException;
import com.atlassian.pocketknife.api.customfields.service.CustomFieldMetadata;
import com.atlassian.pocketknife.api.customfields.service.GlobalCustomFieldService;
import io.atlassian.fugue.Option;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ApprovalsCFManager {
    private static final Logger log = LoggerFactory.getLogger(ApprovalsCFManager.class);
    private final CustomFieldMetadata customFieldMetaData = CustomFieldMetadata.builder().fieldName("sd.approval.customfield.name").fieldDescription("sd.approval.customfield.desc").fieldType("com.atlassian.servicedesk.approvals-plugin:sd-approvals").fieldSearcher("com.atlassian.servicedesk.approvals-plugin:sd-approvals-searcher").lockField(true).build();
    private final GlobalCustomFieldService globalCustomFieldService;

    @Autowired
    public ApprovalsCFManager(@Nonnull GlobalCustomFieldService globalCustomFieldService) {
        this.globalCustomFieldService = globalCustomFieldService;
    }

    public Option<CustomField> getOrCreateApprovalsCF() {
        try {
            CustomField cf = this.globalCustomFieldService.getGlobalCustomField(this.customFieldMetaData);
            return Option.option((Object)cf);
        }
        catch (CustomFieldException e) {
            log.error(e.getMessage());
            return Option.none();
        }
    }
}

