/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.approvals.internal.contextprovider;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.web.ContextProvider;
import com.atlassian.servicedesk.plugins.approvals.internal.webpanel.view.ApprovalsListPortalViewData;
import com.atlassian.servicedesk.plugins.approvals.internal.webpanel.view.ApprovalsViewDataHelper;
import io.atlassian.fugue.Option;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PortalApprovalDataContextProvider
implements ContextProvider {
    private final ApprovalsViewDataHelper approvalsViewDataHelper;

    @Autowired
    public PortalApprovalDataContextProvider(ApprovalsViewDataHelper approvalsViewDataHelper) {
        this.approvalsViewDataHelper = approvalsViewDataHelper;
    }

    public void init(Map<String, String> map) throws PluginParseException {
    }

    public Map<String, Object> getContextMap(Map<String, Object> context) {
        Option<ApplicationUser> user = this.getUser(context);
        Option<Issue> issue = this.getIssue(context);
        if (user.isEmpty() || issue.isEmpty()) {
            return context;
        }
        ApprovalsListPortalViewData approvals = this.approvalsViewDataHelper.getApprovalsForCustomerPortal((ApplicationUser)user.get(), (Issue)issue.get());
        context.put("approvals", approvals);
        return context;
    }

    private Option<ApplicationUser> getUser(Map<String, Object> context) {
        return Option.option((Object)((ApplicationUser)context.get("user")));
    }

    private Option<Issue> getIssue(Map<String, Object> context) {
        return Option.option((Object)((Issue)context.get("issue")));
    }
}

