/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.approvals.internal.contextprovider;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.web.ContextProvider;
import com.atlassian.servicedesk.plugins.approvals.internal.webpanel.view.ApprovalsListIssueViewData;
import com.atlassian.servicedesk.plugins.approvals.internal.webpanel.view.ApprovalsViewDataHelper;
import io.atlassian.fugue.Option;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ApprovalsDataContextProvider
implements ContextProvider {
    static final String APPROVALS_KEY = "approvals";
    static final String ISSUE_KEY = "issue";
    static final String USER_KEY = "user";
    private final ApprovalsViewDataHelper approvalsViewDataHelper;

    @Autowired
    public ApprovalsDataContextProvider(ApprovalsViewDataHelper approvalsViewDataHelper) {
        this.approvalsViewDataHelper = approvalsViewDataHelper;
    }

    public void init(Map<String, String> params) throws PluginParseException {
    }

    public Map<String, Object> getContextMap(Map<String, Object> context) {
        Option<ApplicationUser> user = this.getUser(context);
        Option<Issue> issue = this.getIssue(context);
        if (!user.isDefined() || !issue.isDefined()) {
            return context;
        }
        ApprovalsListIssueViewData approvals = this.approvalsViewDataHelper.getApprovals((ApplicationUser)user.get(), (Issue)issue.get());
        context.put(APPROVALS_KEY, approvals);
        return context;
    }

    private Option<ApplicationUser> getUser(Map<String, Object> context) {
        return Option.option((Object)((ApplicationUser)context.get(USER_KEY)));
    }

    private Option<Issue> getIssue(Map<String, Object> context) {
        return Option.option((Object)((Issue)context.get(ISSUE_KEY)));
    }
}

