/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.approvals.internal.bootstrap.lifecycle;

import com.atlassian.jira.jql.operand.JqlOperandResolver;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.servicedesk.plugins.approvals.internal.searcher.index.ApprovalsIndexerDataManager;
import com.atlassian.servicedesk.plugins.approvals.internal.searcher.query.ApprovalsClauseQueryCreationDelegator;
import java.util.concurrent.atomic.AtomicReference;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ApprovalComponentAccessor
implements InitializingBean,
DisposableBean {
    private static final AtomicReference<ApprovalComponentAccessor> instance = new AtomicReference();
    private final ApprovalsIndexerDataManager indexerDataHelper;
    private final ApprovalsClauseQueryCreationDelegator clauseQueryCreationDelegator;
    private final JqlOperandResolver jqlOperandResolver;
    private final I18nHelper i18nHelper;

    @Autowired
    public ApprovalComponentAccessor(ApprovalsIndexerDataManager indexerDataHelper, ApprovalsClauseQueryCreationDelegator clauseQueryCreationDelegator, JqlOperandResolver jqlOperandResolver, I18nHelper i18nHelper) {
        this.indexerDataHelper = indexerDataHelper;
        this.clauseQueryCreationDelegator = clauseQueryCreationDelegator;
        this.jqlOperandResolver = jqlOperandResolver;
        this.i18nHelper = i18nHelper;
    }

    public void afterPropertiesSet() throws Exception {
        instance.set(this);
    }

    public void destroy() throws Exception {
        instance.set(null);
    }

    private static ApprovalComponentAccessor get() {
        ApprovalComponentAccessor accessor = instance.get();
        if (accessor == null) {
            throw new IllegalStateException("You have called on this too early.  Spring has not auto-wired it yet.");
        }
        return accessor;
    }

    public static ApprovalsIndexerDataManager getApprovalIndexerDataHelper() {
        return ApprovalComponentAccessor.get().indexerDataHelper;
    }

    public static ApprovalsClauseQueryCreationDelegator getClauseQueryCreationDelegator() {
        return ApprovalComponentAccessor.get().clauseQueryCreationDelegator;
    }

    public static JqlOperandResolver getJqlOperandResolver() {
        return ApprovalComponentAccessor.get().jqlOperandResolver;
    }

    public static I18nHelper getI18nHelper() {
        return ApprovalComponentAccessor.get().i18nHelper;
    }
}

