/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.approvals.internal.bootstrap.featureflag;

import com.atlassian.jira.config.FeatureFlag;
import com.atlassian.jira.config.FeatureFlagProvider;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.Validate;

public class SDApprovalsFeatureFlags
implements FeatureFlagProvider {
    private static final Set<FeatureFlag> featureFlags = new HashSet<FeatureFlag>();
    public static final FeatureFlag APPROVALS_LIGHT_WEIGHT = SDApprovalsFeatureFlags.registerFlag("sd.approvals.light.weight", false);
    public static final FeatureFlag APPROVAL_REQUESTED_WHEN_HANDLER = SDApprovalsFeatureFlags.registerFlag("sd.approval.requested.when.handler", true);

    protected static FeatureFlag registerFlag(String featureKey, boolean defaultOn) {
        SDApprovalsFeatureFlags.validate(featureKey);
        FeatureFlag featureFlag = FeatureFlag.featureFlag((String)featureKey).defaultedTo(defaultOn);
        featureFlags.add(featureFlag);
        return featureFlag;
    }

    public Set<FeatureFlag> getFeatureFlags() {
        return featureFlags;
    }

    protected static void validate(String featureKey) {
        Validate.notNull((Object)featureKey, (String)"FeatureKey must not be null");
        Validate.isTrue((boolean)SDApprovalsFeatureFlags.featureKeyIsNotEndWithPrefix(featureKey), (String)"Invalid feature key provided, key should be of the form 'sd.feature.flag', NOT 'sd.feature.flag.enabled' or 'sd.feature.flag.disabled'");
        Validate.isTrue((boolean)SDApprovalsFeatureFlags.featureKeyDoesNotExists(featureKey), (String)String.format("Feature key %s already registered", featureKey));
    }

    protected static boolean featureKeyIsNotEndWithPrefix(String featureKey) {
        return !featureKey.endsWith(".enabled") && !featureKey.endsWith(".disabled");
    }

    protected static boolean featureKeyDoesNotExists(String featureKey) {
        for (FeatureFlag featureFlag : featureFlags) {
            if (!featureKey.equals(featureFlag.featureKey())) continue;
            return false;
        }
        return true;
    }
}

