/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.approvals.internal.approver;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.servicedesk.internal.api.approver.ApproverConfiguration;
import com.atlassian.servicedesk.internal.api.approver.ApproverConfigurationDataInput;
import com.atlassian.servicedesk.internal.api.approver.ApproverConfigurationType;
import com.atlassian.servicedesk.internal.api.approver.UserApproverConfiguration;
import com.atlassian.servicedesk.plugins.approvals.internal.approver.ApproverConfigurationData;
import com.atlassian.servicedesk.plugins.approvals.internal.approver.ApproverConfigurationHandler;
import com.atlassian.servicedesk.plugins.approvals.internal.approver.UserApproverConfigurationDataInput;
import com.atlassian.servicedesk.plugins.approvals.internal.approver.UserApproverConfigurationImpl;
import com.atlassian.servicedesk.plugins.approvals.internal.util.ApprovalError;
import com.google.common.collect.Sets;
import io.atlassian.fugue.Either;
import io.atlassian.fugue.Maybe;
import io.atlassian.fugue.Option;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class UserApproverTypeConfigurationHandler
implements ApproverConfigurationHandler {
    private final UserManager userManager;
    private final ApprovalError approvalError;

    @Autowired
    public UserApproverTypeConfigurationHandler(UserManager userManager, ApprovalError approvalError) {
        this.userManager = userManager;
        this.approvalError = approvalError;
    }

    @Override
    public ApproverConfigurationType getType() {
        return ApproverConfigurationType.USER;
    }

    @Override
    public boolean isApprover(ApplicationUser user, Issue issue, Collection<ApproverConfigurationData> datas) {
        return this.getUsers(issue, datas).contains(user);
    }

    @Override
    public Set<ApplicationUser> getUsers(Issue issue, Collection<ApproverConfigurationData> datas) {
        HashSet users = Sets.newHashSet();
        for (ApproverConfigurationData data : datas) {
            Option<UserApproverConfiguration> userConfiguration = this.getUserConfiguration(data);
            if (!userConfiguration.isDefined()) continue;
            users.add(((UserApproverConfiguration)userConfiguration.get()).getUser());
        }
        return users;
    }

    @Override
    public boolean hasValidApproverConfigurationData(Collection<ApproverConfigurationData> datas) {
        return this.getApproverConfigurations(datas).size() > 0;
    }

    @Override
    public Collection<ApproverConfiguration> getApproverConfigurations(Collection<ApproverConfigurationData> datas) {
        return datas.stream().map(this::getUserConfiguration).filter(Maybe::isDefined).map(Maybe::get).collect(Collectors.toList());
    }

    private Option<UserApproverConfiguration> getUserConfiguration(ApproverConfigurationData approverConfigurationData) {
        String userKey = approverConfigurationData.getValue();
        ApplicationUser user = this.userManager.getUserByKey(userKey);
        if (user != null) {
            return Option.some((Object)new UserApproverConfigurationImpl(approverConfigurationData.getApprovalId(), user));
        }
        return Option.none();
    }

    public Either<AnError, Collection<ApproverConfigurationDataInput>> toDataInput(Collection<String> userNames) {
        ArrayList configurationDataInputs = new ArrayList();
        if (!userNames.isEmpty()) {
            Either<AnError, Collection<ApplicationUser>> userApproversEith = this.toApplicationUsers(userNames);
            if (userApproversEith.isLeft()) {
                return Either.left((Object)userApproversEith.left().get());
            }
            Collection userApprovers = (Collection)userApproversEith.right().get();
            userApprovers.stream().forEach(user -> configurationDataInputs.add(new UserApproverConfigurationDataInput((ApplicationUser)user)));
        }
        return Either.right(configurationDataInputs);
    }

    private Either<AnError, Collection<ApplicationUser>> toApplicationUsers(Collection<String> userNames) {
        HashSet<ApplicationUser> users = new HashSet<ApplicationUser>();
        for (String username : userNames) {
            ApplicationUser user = this.userManager.getUserByName(username);
            if (user != null && user.isActive()) {
                users.add(user);
                continue;
            }
            return Either.left((Object)this.approvalError.INVALID_USER(username));
        }
        return Either.right(users);
    }
}

