/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.approvals.internal.approver;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.querydsl.DatabaseAccessor;
import com.atlassian.pocketknife.api.querydsl.DatabaseConnection;
import com.atlassian.servicedesk.api.approval.Approval;
import com.atlassian.servicedesk.internal.api.approver.ApproverConfiguration;
import com.atlassian.servicedesk.internal.api.approver.ApproverConfigurationDataInput;
import com.atlassian.servicedesk.plugins.approvals.internal.approval.ApprovalImpl;
import com.atlassian.servicedesk.plugins.approvals.internal.approver.ApproverConfigurationData;
import com.atlassian.servicedesk.plugins.approvals.internal.approver.ApproverConfigurationDelegator;
import com.atlassian.servicedesk.plugins.approvals.internal.approver.ApproverManager;
import com.atlassian.servicedesk.plugins.approvals.internal.dao.ApproverDao;
import com.atlassian.servicedesk.plugins.approvals.internal.util.ApprovalError;
import io.atlassian.fugue.Either;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ApproverManagerImpl
implements ApproverManager {
    private final ApproverDao approverDao;
    private final DatabaseAccessor databaseAccessor;
    private final ApproverConfigurationDelegator approverConfigurationDelegator;
    private final IssueManager issueManager;
    private final ApprovalError approvalError;

    @Autowired
    public ApproverManagerImpl(ApproverDao approverDao, DatabaseAccessor databaseAccessor, ApproverConfigurationDelegator approverConfigurationDelegator, IssueManager issueManager, ApprovalError approvalError) {
        this.approverDao = approverDao;
        this.databaseAccessor = databaseAccessor;
        this.approverConfigurationDelegator = approverConfigurationDelegator;
        this.issueManager = issueManager;
        this.approvalError = approvalError;
    }

    @Override
    public boolean create(Approval approval, Collection<ApproverConfigurationDataInput> configurations, DatabaseConnection databaseConnection) {
        this.approverDao.create(approval, configurations, databaseConnection);
        return true;
    }

    @Override
    public boolean isApprover(ApplicationUser user, Issue issue) {
        Collection<ApproverConfigurationData> data = this.getDataForIssue(issue);
        return this.approverConfigurationDelegator.isApprover(user, issue, data);
    }

    @Override
    public boolean hasValidApproverConfigurationData(Approval approval) {
        Collection<ApproverConfigurationData> configuration = this.getDataForApproval(approval);
        return this.approverConfigurationDelegator.isValidApproverConfigurationData(configuration);
    }

    @Override
    public Collection<ApproverConfiguration> getApproverConfigurations(Approval approval) {
        Collection<ApproverConfigurationData> configuration = this.getDataForApproval(approval);
        return this.approverConfigurationDelegator.getApproverConfigurations(configuration);
    }

    @Override
    public boolean isApprover(ApplicationUser user, Approval approval) {
        Either<AnError, Issue> issueEither = this.getIssueForApproval(approval);
        if (issueEither.isLeft()) {
            return false;
        }
        Issue issue = (Issue)issueEither.right().get();
        Collection<ApproverConfigurationData> data = this.getDataForApproval(approval);
        return this.approverConfigurationDelegator.isApprover(user, issue, data);
    }

    @Override
    public Collection<ApplicationUser> getApprovers(Approval approval) {
        Either<AnError, Issue> issueEither = this.getIssueForApproval(approval);
        if (issueEither.isLeft()) {
            return Collections.emptyList();
        }
        Issue issue = (Issue)issueEither.right().get();
        Collection<ApproverConfigurationData> data = this.getDataForApproval(approval);
        return this.approverConfigurationDelegator.getApprovers(issue, data);
    }

    @Override
    public Set<ApplicationUser> getApprovers(Issue issue) {
        Collection<ApproverConfigurationData> datas = this.getDataForIssue(issue);
        return this.approverConfigurationDelegator.getApprovers(issue, datas);
    }

    private Collection<ApproverConfigurationData> getDataForIssue(Issue issue) {
        return (Collection)this.databaseAccessor.run(databaseConnection -> this.approverDao.getAllApproverConfigurations(issue, (DatabaseConnection)databaseConnection));
    }

    private Collection<ApproverConfigurationData> getDataForApproval(Approval approval) {
        return (Collection)this.databaseAccessor.run(databaseConnection -> this.approverDao.getApproverData(approval, (DatabaseConnection)databaseConnection));
    }

    public Either<AnError, Issue> getIssueForApproval(Approval approval) {
        ApprovalImpl approvalImpl = (ApprovalImpl)approval;
        MutableIssue issue = this.issueManager.getIssueObject(Long.valueOf(approvalImpl.getIssueId()));
        if (issue != null) {
            return Either.right((Object)issue);
        }
        return Either.left((Object)this.approvalError.ISSUE_NOT_FOUND());
    }
}

