/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.approvals.internal.approver;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.servicedesk.internal.api.approver.ApproverConfiguration;
import com.atlassian.servicedesk.internal.api.approver.ApproverConfigurationType;
import com.atlassian.servicedesk.plugins.approvals.internal.approver.ApproverConfigurationData;
import com.atlassian.servicedesk.plugins.approvals.internal.approver.ApproverConfigurationDelegator;
import com.atlassian.servicedesk.plugins.approvals.internal.approver.ApproverConfigurationHandler;
import com.atlassian.servicedesk.plugins.approvals.internal.approver.CustomFieldApproverTypeConfigurationHandler;
import com.atlassian.servicedesk.plugins.approvals.internal.approver.UserApproverTypeConfigurationHandler;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ApproverConfigurationDelegatorImpl
implements ApproverConfigurationDelegator {
    private final UserApproverTypeConfigurationHandler userApproverProvider;
    private final CustomFieldApproverTypeConfigurationHandler customFieldApproverProvider;

    @Autowired
    public ApproverConfigurationDelegatorImpl(@Nonnull UserApproverTypeConfigurationHandler userApproverProvider, @Nonnull CustomFieldApproverTypeConfigurationHandler customFieldApproverProvider) {
        this.userApproverProvider = userApproverProvider;
        this.customFieldApproverProvider = customFieldApproverProvider;
    }

    @Override
    public boolean isApprover(ApplicationUser user, Issue issue, Collection<ApproverConfigurationData> datas) {
        Map<ApproverConfigurationType, Collection<ApproverConfigurationData>> dataByType = this.toDataByType(datas);
        for (Map.Entry<ApproverConfigurationType, Collection<ApproverConfigurationData>> entry : dataByType.entrySet()) {
            ApproverConfigurationHandler handler = this.getHandlerForType(entry.getKey());
            boolean isApprover = handler.isApprover(user, issue, entry.getValue());
            if (!isApprover) continue;
            return true;
        }
        return false;
    }

    @Override
    public Set<ApplicationUser> getApprovers(Issue issue, Collection<ApproverConfigurationData> datas) {
        HashSet approvers = Sets.newHashSet();
        Map<ApproverConfigurationType, Collection<ApproverConfigurationData>> dataByType = this.toDataByType(datas);
        for (Map.Entry<ApproverConfigurationType, Collection<ApproverConfigurationData>> entry : dataByType.entrySet()) {
            ApproverConfigurationHandler handler = this.getHandlerForType(entry.getKey());
            Set<ApplicationUser> users = handler.getUsers(issue, entry.getValue());
            approvers.addAll(users);
        }
        return approvers;
    }

    @Override
    public boolean isValidApproverConfigurationData(Collection<ApproverConfigurationData> datas) {
        Map<ApproverConfigurationType, Collection<ApproverConfigurationData>> dataByType = this.toDataByType(datas);
        for (Map.Entry<ApproverConfigurationType, Collection<ApproverConfigurationData>> entry : dataByType.entrySet()) {
            ApproverConfigurationHandler handler = this.getHandlerForType(entry.getKey());
            if (!handler.hasValidApproverConfigurationData(entry.getValue())) continue;
            return true;
        }
        return false;
    }

    @Override
    public Collection<ApproverConfiguration> getApproverConfigurations(Collection<ApproverConfigurationData> datas) {
        ArrayList<ApproverConfiguration> configurations = new ArrayList<ApproverConfiguration>();
        Map<ApproverConfigurationType, Collection<ApproverConfigurationData>> dataByType = this.toDataByType(datas);
        for (Map.Entry<ApproverConfigurationType, Collection<ApproverConfigurationData>> entry : dataByType.entrySet()) {
            ApproverConfigurationHandler handler = this.getHandlerForType(entry.getKey());
            Collection<ApproverConfiguration> result = handler.getApproverConfigurations(datas);
            configurations.addAll(result);
        }
        return configurations;
    }

    private Map<ApproverConfigurationType, Collection<ApproverConfigurationData>> toDataByType(Collection<ApproverConfigurationData> datas) {
        HashMap dataByType = Maps.newHashMap();
        List userDatas = datas.stream().filter(data -> this.userApproverProvider.getType().equals((Object)data.getApproverConfigurationType())).collect(Collectors.toList());
        List cfDatas = datas.stream().filter(data -> this.customFieldApproverProvider.getType().equals((Object)data.getApproverConfigurationType())).collect(Collectors.toList());
        dataByType.put(this.userApproverProvider.getType(), userDatas);
        dataByType.put(this.customFieldApproverProvider.getType(), cfDatas);
        return dataByType;
    }

    private ApproverConfigurationHandler getHandlerForType(ApproverConfigurationType type) {
        switch (type) {
            case USER: {
                return this.userApproverProvider;
            }
            case CUSTOM_FIELD: {
                return this.customFieldApproverProvider;
            }
        }
        throw new RuntimeException("No provider for approver configuration type " + type);
    }
}

