/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.approvals.internal.approval;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.servicedesk.api.approval.Approval;
import com.atlassian.servicedesk.api.approval.ApprovalDecisionType;
import com.atlassian.servicedesk.internal.api.approval.CreateApprovalParameters;
import com.atlassian.servicedesk.internal.api.approval.InternalApprovalService;
import com.atlassian.servicedesk.plugins.approvals.internal.approval.ApprovalManager;
import com.atlassian.servicedesk.plugins.approvals.internal.approval.CreateApprovalParametersImpl;
import com.atlassian.servicedesk.plugins.approvals.internal.events.ApprovalEventDispatcher;
import com.atlassian.servicedesk.plugins.approvals.internal.util.ApprovalError;
import com.atlassian.servicedesk.plugins.approvals.internal.util.ApprovalPermissionChecker;
import io.atlassian.fugue.Either;
import java.util.Collection;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@ExportAsService
public class InternalApprovalServiceImpl
implements InternalApprovalService {
    private final ApprovalManager approvalManager;
    private final ApprovalPermissionChecker approvalPermissionChecker;
    private final ApprovalError approvalError;
    private final ApprovalEventDispatcher approvalEventDispatcher;

    @Autowired
    public InternalApprovalServiceImpl(ApprovalManager approvalManager, ApprovalPermissionChecker approvalPermissionChecker, ApprovalError approvalError, ApprovalEventDispatcher approvalEventDispatcher) {
        this.approvalManager = approvalManager;
        this.approvalPermissionChecker = approvalPermissionChecker;
        this.approvalError = approvalError;
        this.approvalEventDispatcher = approvalEventDispatcher;
    }

    public CreateApprovalParameters.Builder newCreateBuilder() {
        return new CreateApprovalParametersImpl.BuilderImpl();
    }

    public Either<AnError, Approval> createApproval(ApplicationUser user, CreateApprovalParameters createApprovalParameters) {
        CreateApprovalParametersImpl approvalInput = (CreateApprovalParametersImpl)createApprovalParameters;
        Either<AnError, ApplicationUser> checkPermissionEith = this.approvalPermissionChecker.canCreateApproval(user, approvalInput.getIssue());
        if (checkPermissionEith.isLeft()) {
            return Either.left((Object)checkPermissionEith.left().get());
        }
        Either<AnError, Approval> result = this.approvalManager.createApproval(createApprovalParameters);
        if (result.isRight()) {
            this.approvalEventDispatcher.dispatchCreatedApprovalEvent((Approval)result.right().get(), user);
        }
        return result;
    }

    public Either<AnError, Collection<Approval>> getApprovals(ApplicationUser user, Issue issue) {
        boolean canView = this.approvalPermissionChecker.canViewApproval(user);
        if (!canView) {
            return Either.left((Object)this.approvalError.VIEW_APPROVAL_PERMISSION());
        }
        return Either.right(this.approvalManager.getApprovalsByIssue(issue));
    }

    public Collection<Approval> getActiveApprovals(Issue issue) {
        return this.approvalManager.getActiveApprovals(issue);
    }

    public boolean hasActiveApprovals(Issue issue) {
        return !this.approvalManager.getActiveApprovals(issue).isEmpty();
    }

    public Either<AnError, Approval> getApprovalById(ApplicationUser user, int approvalId) {
        boolean canView = this.approvalPermissionChecker.canViewApproval(user);
        if (!canView) {
            return Either.left((Object)this.approvalError.VIEW_APPROVAL_PERMISSION());
        }
        return this.approvalManager.getApprovalById(approvalId);
    }

    public Either<AnError, Issue> getIssueForApproval(ApplicationUser user, Approval approval) {
        return this.approvalManager.getIssueForApproval(approval);
    }

    public Either<AnError, Approval> updateApprovalDecisionIgnoreSecurity(ApplicationUser user, Approval approval, ApprovalDecisionType decision) {
        Either<AnError, Approval> result = this.approvalManager.updateApprovalDecision(approval, decision);
        if (result.isLeft()) {
            return result;
        }
        this.approvalEventDispatcher.dispatchApprovalDecisionEvent((Approval)result.right().get(), user);
        return result;
    }
}

