/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.approvals.internal.approval;

import com.atlassian.fugue.Either;
import com.atlassian.fugue.Option;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.api.approval.Approval;
import com.atlassian.servicedesk.api.approval.ApprovalDecisionType;
import com.atlassian.servicedesk.api.approval.ApprovalQuery;
import com.atlassian.servicedesk.api.approval.ApprovalService;
import com.atlassian.servicedesk.api.approval.Approver;
import com.atlassian.servicedesk.api.request.CustomerRequest;
import com.atlassian.servicedesk.api.request.CustomerRequestQuery;
import com.atlassian.servicedesk.api.request.ServiceDeskCustomerRequestService;
import com.atlassian.servicedesk.api.user.UserFactory;
import com.atlassian.servicedesk.api.util.paging.LimitedPagedRequest;
import com.atlassian.servicedesk.api.util.paging.PagedResponse;
import com.atlassian.servicedesk.api.util.paging.PagedResponseImpl;
import com.atlassian.servicedesk.internal.api.approval.InternalApprovalService;
import com.atlassian.servicedesk.internal.api.approver.InternalApproverService;
import com.atlassian.servicedesk.internal.api.decision.ApproverDecision;
import com.atlassian.servicedesk.internal.api.decision.InternalApproverDecisionService;
import com.atlassian.servicedesk.plugins.approvals.internal.approval.ApprovalQueryImpl;
import com.atlassian.servicedesk.plugins.approvals.internal.approver.ApproverImpl;
import com.atlassian.servicedesk.plugins.approvals.internal.rest.ApprovalAssembler;
import com.atlassian.servicedesk.plugins.approvals.internal.util.ApprovalError;
import com.atlassian.servicedesk.plugins.approvals.internal.workflow.configuration.WorkflowApprovalConfigurationHelper;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@ExportAsService
public class ApprovalServiceImpl
implements ApprovalService {
    private final WorkflowApprovalConfigurationHelper workflowApprovalConfigurationHelper;
    private final InternalApprovalService internalApprovalService;
    private final InternalApproverService internalApproverService;
    private final InternalApproverDecisionService internalApproverDecisionService;
    private final ApprovalAssembler approvalAssembler;
    private final ServiceDeskCustomerRequestService sdCustomerRequestService;
    private final UserFactory userFactory;
    private final ApprovalError approvalError;

    @Autowired
    public ApprovalServiceImpl(WorkflowApprovalConfigurationHelper workflowApprovalConfigurationHelper, InternalApprovalService internalApprovalService, InternalApproverService internalApproverService, InternalApproverDecisionService internalApproverDecisionService, ApprovalAssembler approvalAssembler, ServiceDeskCustomerRequestService sdCustomerRequestService, UserFactory userFactory, ApprovalError approvalError) {
        this.workflowApprovalConfigurationHelper = workflowApprovalConfigurationHelper;
        this.internalApprovalService = internalApprovalService;
        this.internalApproverService = internalApproverService;
        this.internalApproverDecisionService = internalApproverDecisionService;
        this.approvalAssembler = approvalAssembler;
        this.sdCustomerRequestService = sdCustomerRequestService;
        this.userFactory = userFactory;
        this.approvalError = approvalError;
    }

    public ApprovalQuery.Builder newQueryBuilder() {
        return ApprovalQueryImpl.newBuilder();
    }

    public Either<AnError, PagedResponse<Approval>> getApprovals(ApplicationUser user, ApprovalQuery approvalQuery) {
        Objects.requireNonNull(user, "user");
        Objects.requireNonNull(approvalQuery, "approvalQuery");
        return StepsConverters.olderEither((io.atlassian.fugue.Either)Steps.begin((io.atlassian.fugue.Either)StepsConverters.newerEither(this.validateApprovalQuery(approvalQuery))).then(query -> StepsConverters.newerEither((Either)this.userFactory.wrap(user))).then((query, checkedUser) -> StepsConverters.newerEither(this.getIssue(user, (Long)query.issue().get()))).then((query, checkedUser, issue) -> this.internalApprovalService.getApprovals(user, issue)).yield((query, checkedUser, issue, approvals) -> PagedResponseImpl.toPagedResponse((LimitedPagedRequest)approvalQuery.pagedRequest(), (List)ImmutableList.copyOf((Collection)approvals))));
    }

    public Either<AnError, Approval> getApprovalById(ApplicationUser user, int approvalId) {
        Objects.requireNonNull(user, "user");
        return StepsConverters.olderEither((io.atlassian.fugue.Either)Steps.begin((io.atlassian.fugue.Either)StepsConverters.newerEither((Either)this.userFactory.wrap(user))).then(checkedUser -> this.internalApprovalService.getApprovalById(user, approvalId)).then((checkedUser, approval) -> StepsConverters.newerEither(this.getIssue(user, approval.getIssueId()))).yield((checkedUser, approval, issue) -> approval));
    }

    public Either<AnError, List<Approver>> getApprovers(ApplicationUser user, Approval approval) {
        Objects.requireNonNull(user, "user");
        Objects.requireNonNull(approval, "approval");
        return StepsConverters.olderEither((io.atlassian.fugue.Either)Steps.begin((io.atlassian.fugue.Either)this.internalApproverService.getApprovers(user, approval)).then(approverUsers -> StepsConverters.newerEither((Either)Either.right((Object)this.internalApproverDecisionService.getApproversDecisions(approval)))).then((approverUsers, approverDecisions) -> StepsConverters.newerEither((Either)Either.right(this.toApprovers((Collection<ApplicationUser>)approverUsers, (Collection<ApproverDecision>)approverDecisions)))).yield((approverUsers, approverDecisions, approvers) -> approvers));
    }

    public Either<AnError, Boolean> canAnswerApproval(ApplicationUser user, Approval approval) {
        Objects.requireNonNull(user, "user");
        Objects.requireNonNull(approval, "approval");
        return StepsConverters.olderEither((io.atlassian.fugue.Either)Steps.begin((io.atlassian.fugue.Either)this.internalApprovalService.getIssueForApproval(user, approval)).then(issue -> StepsConverters.newerEither(this.checkCanAnswerApprovalAgainstIssue(user, (Issue)issue, approval))).yield((issue, canAnswer) -> canAnswer));
    }

    public Either<AnError, Approval> answerApproval(ApplicationUser user, Approval approval, ApprovalDecisionType decision) {
        Objects.requireNonNull(user, "user");
        Objects.requireNonNull(approval, "approval");
        Objects.requireNonNull(decision, "decision");
        return StepsConverters.olderEither((io.atlassian.fugue.Either)Steps.begin((io.atlassian.fugue.Either)StepsConverters.newerEither((Either)this.userFactory.wrap(user))).then(checkedUser -> StepsConverters.newerEither(this.getIssue(user, approval.getIssueId()))).then((checkedUser, issue) -> this.workflowApprovalConfigurationHelper.validateApprovalAgainstCurrentStatus((Issue)issue, approval)).then((checkedUser, issue, isValidApproval) -> StepsConverters.newerEither(this.doAnswerApproval(user, approval, decision))).yield((checkedUser, issue, validApproval, updatedApproval) -> updatedApproval));
    }

    private List<Approver> toApprovers(Collection<ApplicationUser> approverUsers, Collection<ApproverDecision> approverDecisions) {
        return approverUsers.stream().map(user -> this.toApprover((ApplicationUser)user, approverDecisions)).collect(Collectors.toList());
    }

    private Approver toApprover(ApplicationUser approver, Collection<ApproverDecision> approversDecisions) {
        String userKey = approver.getKey();
        for (ApproverDecision approversDecision : approversDecisions) {
            if (!Objects.equals(userKey, approversDecision.getUserKey())) continue;
            return new ApproverImpl(approver, (Option<ApprovalDecisionType>)Option.some((Object)approversDecision.getDecision()));
        }
        return new ApproverImpl(approver, (Option<ApprovalDecisionType>)Option.none());
    }

    private Either<AnError, Boolean> checkCanAnswerApprovalAgainstIssue(ApplicationUser user, Issue issue, Approval approval) {
        if (!this.hasValidApprovalAgainstStatus(issue, approval)) {
            return Either.right((Object)false);
        }
        return this.isApprovalActiveForUser(user, issue, approval);
    }

    private boolean hasValidApprovalAgainstStatus(Issue issue, Approval approval) {
        return this.workflowApprovalConfigurationHelper.validateApprovalAgainstCurrentStatus(issue, approval).isRight();
    }

    private Either<AnError, Boolean> isApprovalActiveForUser(ApplicationUser user, Issue issue, Approval approval) {
        return StepsConverters.olderEither((io.atlassian.fugue.Either)this.internalApproverService.getActiveApprovalsForUser(issue, user).map(activeApprovals -> activeApprovals.stream().anyMatch(activeApproval -> Objects.equals(activeApproval.getId(), approval.getId()))));
    }

    private Either<AnError, Issue> getIssue(ApplicationUser user, long issueId) {
        CustomerRequestQuery customerRequestQuery = this.sdCustomerRequestService.newQueryBuilder().issue(Long.valueOf(issueId)).build();
        return this.sdCustomerRequestService.getCustomerRequests(user, customerRequestQuery).map(request -> ((CustomerRequest)request.findFirst().get()).getIssue());
    }

    private Either<AnError, ApprovalQuery> validateApprovalQuery(ApprovalQuery approvalQuery) {
        if (approvalQuery.issue().isEmpty()) {
            return Either.left((Object)this.approvalError.APPROVAL_QUERY_NOT_VALID());
        }
        return Either.right((Object)approvalQuery);
    }

    private Either<AnError, Approval> doAnswerApproval(ApplicationUser user, Approval approval, ApprovalDecisionType decision) {
        int approvalId = approval.getId();
        return StepsConverters.olderEither((io.atlassian.fugue.Either)this.approvalAssembler.createApproverDecision(user, approvalId, decision).flatMap(approvalResponse -> this.internalApprovalService.getApprovalById(user, approvalId)));
    }
}

