/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.approvals.internal.approval;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.index.IndexException;
import com.atlassian.jira.issue.index.IssueIndexingService;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.querydsl.DatabaseAccessor;
import com.atlassian.pocketknife.api.querydsl.DatabaseConnection;
import com.atlassian.servicedesk.api.approval.Approval;
import com.atlassian.servicedesk.api.approval.ApprovalDecisionType;
import com.atlassian.servicedesk.internal.api.approval.CreateApprovalParameters;
import com.atlassian.servicedesk.internal.api.requirement.ApprovalConditionType;
import com.atlassian.servicedesk.plugins.approvals.internal.approval.ApprovalImpl;
import com.atlassian.servicedesk.plugins.approvals.internal.approval.ApprovalManager;
import com.atlassian.servicedesk.plugins.approvals.internal.approval.CreateApprovalParametersImpl;
import com.atlassian.servicedesk.plugins.approvals.internal.approver.ApproverManager;
import com.atlassian.servicedesk.plugins.approvals.internal.dao.ApprovalDao;
import com.atlassian.servicedesk.plugins.approvals.internal.util.ApprovalError;
import com.atlassian.servicedesk.plugins.approvals.internal.workflow.configuration.WorkflowApprovalConfigurationHelper;
import com.atlassian.util.concurrent.Assertions;
import io.atlassian.fugue.Either;
import io.atlassian.fugue.Option;
import java.util.Collection;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ApprovalManagerImpl
implements ApprovalManager {
    private final Logger log = LoggerFactory.getLogger(ApprovalManagerImpl.class);
    private final ApprovalDao approvalDao;
    private final ApproverManager approverManager;
    private final ApprovalError approvalError;
    private final DatabaseAccessor databaseAccessor;
    private final IssueIndexingService issueIndexingService;
    private final IssueManager issueManager;
    private final WorkflowApprovalConfigurationHelper workflowApprovalConfigHelper;
    private static final int NAME_LIMIT = 100;

    @Autowired
    public ApprovalManagerImpl(ApprovalDao approvalDao, ApproverManager approverManager, ApprovalError approvalError, DatabaseAccessor databaseAccessor, IssueIndexingService issueIndexingService, IssueManager issueManager, WorkflowApprovalConfigurationHelper workflowApprovalConfigHelper) {
        this.approvalDao = approvalDao;
        this.approverManager = approverManager;
        this.approvalError = approvalError;
        this.databaseAccessor = databaseAccessor;
        this.issueIndexingService = issueIndexingService;
        this.issueManager = issueManager;
        this.workflowApprovalConfigHelper = workflowApprovalConfigHelper;
    }

    @Override
    public Either<AnError, Approval> createApproval(CreateApprovalParameters createApprovalParameters) {
        Either<AnError, CreateApprovalParameters> validatedResult = this.validateCreateRequest(createApprovalParameters);
        if (validatedResult.isLeft()) {
            return Either.left((Object)validatedResult.left().get());
        }
        CreateApprovalParametersImpl createParameterImpl = (CreateApprovalParametersImpl)validatedResult.right().get();
        Either approvalEither = (Either)this.databaseAccessor.runInTransaction(databaseConnection -> {
            Option<Approval> approval = this.approvalDao.create(createApprovalParameters, (DatabaseConnection)databaseConnection);
            if (approval.isEmpty()) {
                return Either.left((Object)this.approvalError.APPROVAL_DATABASE_CREATION_FAILED());
            }
            this.approverManager.create((Approval)approval.get(), createParameterImpl.getConfigurationInputs(), (DatabaseConnection)databaseConnection);
            return Either.right((Object)approval.get());
        });
        if (approvalEither.isRight()) {
            this.reindexIssue(createParameterImpl.getIssue());
        }
        return approvalEither;
    }

    @Override
    public Either<AnError, Approval> getApprovalById(int approvalId) {
        Option approvalOpt = (Option)this.databaseAccessor.runInTransaction(databaseConnection -> this.approvalDao.getById(approvalId, (DatabaseConnection)databaseConnection));
        return approvalOpt.toRight(this.approvalError::APPROVAL_NOT_FOUND);
    }

    @Override
    public Collection<Approval> getApprovalsByIds(Collection<Integer> approvalIds) {
        return (Collection)this.databaseAccessor.runInTransaction(databaseConnection -> this.approvalDao.getByIds(approvalIds, (DatabaseConnection)databaseConnection));
    }

    @Override
    public Collection<Approval> getApprovalsByIssue(Issue issue) {
        return (Collection)this.databaseAccessor.runInTransaction(databaseConnection -> this.approvalDao.getApprovalsByIssue(issue, (DatabaseConnection)databaseConnection).stream().filter(approval -> this.isValidApproval(issue, (Approval)approval)).collect(Collectors.toList()));
    }

    @Override
    public Collection<Approval> getActiveApprovals(Issue issue) {
        return (Collection)this.databaseAccessor.runInTransaction(databaseConnection -> this.approvalDao.getActiveApprovals(issue, (DatabaseConnection)databaseConnection).stream().filter(approval -> this.isValidApproval(issue, (Approval)approval)).collect(Collectors.toList()));
    }

    @Override
    public Either<AnError, Approval> updateApprovalDecision(Approval approval, ApprovalDecisionType decision) {
        Either result = (Either)this.databaseAccessor.runInTransaction(databaseConnection -> {
            Option<Approval> approvalOption = this.approvalDao.setFinalDecision(approval, decision, (DatabaseConnection)databaseConnection);
            return Either.right((Object)approvalOption.get());
        });
        if (result.isRight()) {
            this.reindex((Approval)result.right().get());
        }
        return result;
    }

    @Override
    public Either<AnError, Issue> getIssueForApproval(Approval approval) {
        ApprovalImpl approvalImpl = (ApprovalImpl)approval;
        MutableIssue issue = this.issueManager.getIssueObject(Long.valueOf(approvalImpl.getIssueId()));
        if (issue != null) {
            return Either.right((Object)issue);
        }
        return Either.left((Object)this.approvalError.ISSUE_NOT_FOUND());
    }

    @Override
    public void reindex(Approval approval) {
        Either<AnError, Issue> issueEither = this.getIssueForApproval(approval);
        if (issueEither.isLeft()) {
            return;
        }
        this.reindexIssue((Issue)issueEither.right().get());
    }

    @Override
    public boolean isValidApproval(Issue issue, Approval approval) {
        return approval.getDecision().isDefined() || this.approverManager.hasValidApproverConfigurationData(approval) && this.workflowApprovalConfigHelper.validateApprovalAgainstCurrentStatus(issue, approval).isRight();
    }

    private Either<AnError, CreateApprovalParameters> validateCreateRequest(@Nonnull CreateApprovalParameters createApprovalParameters) {
        Assertions.notNull((String)"createRequest is required", (Object)createApprovalParameters);
        CreateApprovalParametersImpl createInput = (CreateApprovalParametersImpl)createApprovalParameters;
        if (StringUtils.isBlank((String)createInput.getName())) {
            return Either.left((Object)this.approvalError.APPROVAL_NAME_REQUIRED());
        }
        if (createInput.getName().length() > 100) {
            return Either.left((Object)this.approvalError.APPROVAL_NAME_TOO_LONG(100));
        }
        if (createInput.getConfigurationInputs().isEmpty()) {
            return Either.left((Object)this.approvalError.AT_LEAST_ONE_APPROVER());
        }
        if (createInput.getApprovalCondition() == null) {
            return Either.left((Object)this.approvalError.APPROVAL_CONDITION_MUST_BE_SPECIFIED());
        }
        String conditionString = createInput.getApprovalCondition().getConditionValue();
        if (StringUtils.isBlank((String)conditionString)) {
            return Either.left((Object)this.approvalError.APPROVAL_CONDITION_MUST_BE_SPECIFIED());
        }
        if (!StringUtils.isNumeric((String)conditionString)) {
            return Either.left((Object)this.approvalError.INVALID_APPROVAL_CONDITION_VALUE());
        }
        int conditionValue = Integer.parseInt(conditionString);
        if (conditionValue < 0) {
            return Either.left((Object)this.approvalError.NEGATIVE_APPROVAL_CONDITION_VALUE());
        }
        if (createInput.getApprovalCondition().getConditionType().equals(ApprovalConditionType.PERCENT.value()) && conditionValue > 100) {
            return Either.left((Object)this.approvalError.INVALID_APPROVAL_CONDITION_VALUE_FOR_PERCENT());
        }
        return Either.right((Object)createApprovalParameters);
    }

    private void reindexIssue(Issue issue) {
        try {
            this.issueIndexingService.reIndex(issue);
        }
        catch (IndexException ex) {
            this.log.warn("Failed to reindex issue=" + issue.getKey());
        }
    }
}

