/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.approvals.internal.approval;

import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.servicedesk.api.approval.Approval;
import com.atlassian.servicedesk.api.approval.ApprovalDecisionType;
import com.atlassian.servicedesk.internal.api.approval.ApprovalChangeListenerService;
import com.atlassian.servicedesk.internal.api.approval.InternalApprovalService;
import com.atlassian.servicedesk.internal.api.requirement.ApprovalRequirementService;
import com.atlassian.servicedesk.plugins.approvals.internal.approval.ApprovalManager;
import io.atlassian.fugue.Either;
import io.atlassian.fugue.Option;
import java.util.Collection;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ApprovalChangeListenerServiceImpl
implements ApprovalChangeListenerService {
    private final ApprovalRequirementService approvalRequirementService;
    private final InternalApprovalService approvalService;
    private final ApprovalManager approvalManager;

    @Autowired
    public ApprovalChangeListenerServiceImpl(ApprovalRequirementService approvalRequirementService, InternalApprovalService approvalService, ApprovalManager approvalManager) {
        this.approvalRequirementService = approvalRequirementService;
        this.approvalService = approvalService;
        this.approvalManager = approvalManager;
    }

    public Collection<Approval> updateApprovalDecisionStateOrReturnOriginal(ApplicationUser user, Collection<Approval> approvals) {
        return approvals.stream().map(approval -> (Approval)this.updateDecision(user, (Approval)approval).getOrElse(approval)).collect(Collectors.toList());
    }

    public void updateApprovalDecisionStateAndReindexApproval(ApplicationUser user, Approval approval) {
        Option<Approval> updatedApproval = this.updateDecision(user, approval);
        if (updatedApproval.isEmpty()) {
            this.approvalManager.reindex(approval);
        }
    }

    private Option<Approval> updateDecision(ApplicationUser user, Approval approval) {
        Either approvalEither;
        Option outcome;
        if (approval.getDecision().isEmpty() && (outcome = this.approvalRequirementService.calculateDecision(user, approval)).isDefined() && (approvalEither = this.approvalService.updateApprovalDecisionIgnoreSecurity(user, approval, (ApprovalDecisionType)outcome.get())).isRight()) {
            return approvalEither.toOption();
        }
        return Option.none();
    }
}

