/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.approvals.internal.activitystream;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.servicedesk.api.approval.Approval;
import com.atlassian.servicedesk.api.approval.ApprovalDecisionType;
import com.atlassian.servicedesk.internal.api.approval.InternalApprovalService;
import com.atlassian.servicedesk.internal.api.decision.ApproverDecision;
import com.atlassian.servicedesk.internal.api.decision.InternalApproverDecisionService;
import com.atlassian.servicedesk.internal.api.request.activitystream.items.ActivityItem;
import com.atlassian.servicedesk.internal.api.requirement.ApprovalRequirementService;
import com.atlassian.servicedesk.internal.spi.request.activitystream.items.ActivityItemComparator;
import com.atlassian.servicedesk.internal.spi.request.activitystream.items.ApprovalCreatedActivityItem;
import com.atlassian.servicedesk.internal.spi.request.activitystream.items.ApproverDecisionActivityItem;
import com.atlassian.servicedesk.internal.spi.request.activitystream.providers.ActivityProvider;
import com.atlassian.servicedesk.plugins.approvals.internal.decision.ApproverDecisionDefaultComparator;
import com.atlassian.servicedesk.plugins.approvals.internal.webpanel.view.ApprovalDecisionViewData;
import io.atlassian.fugue.Either;
import io.atlassian.fugue.Option;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ApprovalsActivityProvider
implements ActivityProvider {
    private final InternalApprovalService approvalService;
    private final InternalApproverDecisionService approverDecisionService;
    private final ApprovalRequirementService approvalRequirementService;
    private final UserManager userManager;

    @Autowired
    public ApprovalsActivityProvider(InternalApprovalService approvalService, InternalApproverDecisionService approverDecisionService, ApprovalRequirementService approvalRequirementService, UserManager userManager) {
        this.approvalService = approvalService;
        this.approverDecisionService = approverDecisionService;
        this.approvalRequirementService = approvalRequirementService;
        this.userManager = userManager;
    }

    public List<ActivityItem> getActivityStream(ApplicationUser user, Issue issue) {
        Either approvalsEither = this.approvalService.getApprovals(user, issue);
        if (approvalsEither.isLeft()) {
            return new ArrayList<ActivityItem>();
        }
        Collection approvals = (Collection)approvalsEither.right().get();
        List<ActivityItem> activityItems = this.buildActivityStream(user, approvals);
        activityItems.sort((Comparator<ActivityItem>)new ActivityItemComparator());
        return activityItems;
    }

    private List<ActivityItem> buildActivityStream(ApplicationUser user, Collection<Approval> approvals) {
        ArrayList<ActivityItem> activities = new ArrayList<ActivityItem>();
        for (Approval approval : approvals) {
            activities.addAll(this.getApprovalActivityItems(user, approval));
        }
        return activities;
    }

    private List<ActivityItem> getApprovalActivityItems(ApplicationUser user, Approval approval) {
        ArrayList<ActivityItem> activities = new ArrayList<ActivityItem>();
        ArrayList<ApproverDecision> decisions = new ArrayList<ApproverDecision>(this.approverDecisionService.getApproversDecisions(approval));
        Option pendingCount = this.approvalRequirementService.getRemainingApproveDecisionsUntilApproved(user, approval);
        if (decisions.isEmpty()) {
            activities.add(this.createApprovalCreatedActivityItem(approval, (Option<Integer>)pendingCount));
        } else {
            activities.add(this.createApprovalCreatedActivityItem(approval, (Option<Integer>)Option.none()));
            activities.addAll(this.createApproverDecisionActivityItems(decisions, (Option<Integer>)pendingCount));
        }
        return activities;
    }

    private ActivityItem createApprovalCreatedActivityItem(Approval approval, Option<Integer> pendingCount) {
        Instant instant = approval.getCreatedDate();
        return new ApprovalCreatedActivityItem(instant, pendingCount);
    }

    private List<ActivityItem> createApproverDecisionActivityItems(List<ApproverDecision> decisions, Option<Integer> pendingCount) {
        decisions.sort(new ApproverDecisionDefaultComparator());
        ArrayList<ActivityItem> activities = new ArrayList<ActivityItem>();
        for (int i = 0; i < decisions.size(); ++i) {
            ApproverDecision decision = decisions.get(i);
            Option<Integer> currentPending = Option.none();
            if (i == decisions.size() - 1 && decision.getDecision() == ApprovalDecisionType.APPROVED) {
                currentPending = pendingCount;
            }
            activities.add((ActivityItem)this.createApproverDecisionActivityItem(decision, currentPending));
        }
        return activities;
    }

    private ApproverDecisionActivityItem createApproverDecisionActivityItem(ApproverDecision decision, Option<Integer> pendingCount) {
        Instant instant = decision.getDecisionDate();
        ApplicationUser approver = this.userManager.getUserByKey(decision.getUserKey());
        String approverDecision = ApprovalDecisionViewData.forApprovalDecision(decision.getDecision()).value();
        return new ApproverDecisionActivityItem(instant, Option.option((Object)approver), decision.getUserKey(), approverDecision, pendingCount);
    }
}

