/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.psmq.internal.schema.ao;

import javax.annotation.Nullable;
import net.java.ao.OneToMany;
import net.java.ao.Preload;
import net.java.ao.RawEntity;
import net.java.ao.schema.AutoIncrement;
import net.java.ao.schema.Indexed;
import net.java.ao.schema.NotNull;
import net.java.ao.schema.PrimaryKey;
import net.java.ao.schema.StringLength;
import net.java.ao.schema.Table;
import net.java.ao.schema.Unique;

public class PsmqDbSchema {

    @Preload
    @Table(value="QUEUE_PROPERTY")
    public static interface QueuePropertyAO
    extends RawEntity<Long> {
        @AutoIncrement
        @NotNull
        @PrimaryKey(value="ID")
        public long getID();

        @Nullable
        public Long getLongValue();

        @NotNull
        @StringLength(value=450)
        public String getName();

        @NotNull
        @StringLength(value=1)
        public String getPropertyType();

        @Nullable
        @StringLength(value=450)
        public String getStringValue();

        @NotNull
        public QueueAO getQueue();
    }

    @Preload
    @Table(value="QUEUE")
    public static interface QueueAO
    extends RawEntity<Long> {
        @AutoIncrement
        @NotNull
        @PrimaryKey(value="ID")
        public long getID();

        @Nullable
        @Indexed
        @StringLength(value=127)
        public String getClaimant();

        @Nullable
        public Long getClaimantTime();

        @NotNull
        public Long getCreatedTime();

        @NotNull
        public Long getMessageCount();

        @NotNull
        public Long getModifiedTime();

        @NotNull
        @Unique
        @StringLength(value=255)
        public String getName();

        @NotNull
        @StringLength(value=450)
        public String getPurpose();

        @Nullable
        @Indexed
        @StringLength(value=255)
        public String getTopic();

        @OneToMany
        public MessageAO[] getMessages();

        @OneToMany
        public QueuePropertyAO[] getQueuePropertys();
    }

    @Preload
    @Table(value="MESSAGE_PROPERTY")
    public static interface MessagePropertyAO
    extends RawEntity<Long> {
        @AutoIncrement
        @NotNull
        @PrimaryKey(value="ID")
        public long getID();

        @Nullable
        public Long getLongValue();

        @NotNull
        @StringLength(value=450)
        public String getName();

        @NotNull
        @StringLength(value=1)
        public String getPropertyType();

        @Nullable
        @StringLength(value=450)
        public String getStringValue();

        @NotNull
        public MessageAO getMessage();
    }

    @Preload
    @Table(value="MESSAGE")
    public static interface MessageAO
    extends RawEntity<Long> {
        @AutoIncrement
        @NotNull
        @PrimaryKey(value="ID")
        public long getID();

        @Nullable
        @Indexed
        @StringLength(value=127)
        public String getClaimant();

        @Nullable
        public Long getClaimantTime();

        @NotNull
        public Integer getClaimCount();

        @NotNull
        @Indexed
        @StringLength(value=255)
        public String getContentType();

        @NotNull
        @Indexed
        public Long getCreatedTime();

        @Nullable
        public Long getExpiryTime();

        @Nullable
        @StringLength(value=-1)
        public String getMsgData();

        @NotNull
        @Indexed
        @StringLength(value=127)
        public String getMsgId();

        @NotNull
        public Long getMsgLength();

        @NotNull
        @Indexed
        public Integer getPriority();

        @NotNull
        public Integer getVersion();

        @NotNull
        public QueueAO getQueue();

        @OneToMany
        public MessagePropertyAO[] getMessagePropertys();
    }
}

