/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.workinghours.internal.rest.util;

import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.datetime.DateTimeFormatter;
import com.atlassian.jira.datetime.DateTimeFormatterFactory;
import com.atlassian.jira.datetime.DateTimeStyle;
import com.atlassian.jira.plugins.workinghours.api.calendar.Calendar;
import com.atlassian.jira.plugins.workinghours.api.calendar.CalendarInfo;
import com.atlassian.jira.plugins.workinghours.api.calendar.Holiday;
import com.atlassian.jira.plugins.workinghours.api.calendar.WorkingTime;
import com.atlassian.jira.plugins.workinghours.api.calendar.access.CalendarAccessManager;
import com.atlassian.jira.plugins.workinghours.api.calendar.access.Operation;
import com.atlassian.jira.plugins.workinghours.internal.rest.response.CalendarResponse;
import com.atlassian.jira.plugins.workinghours.internal.rest.response.CalendarsResponse;
import com.atlassian.jira.plugins.workinghours.internal.rest.response.HolidayResponse;
import com.atlassian.jira.plugins.workinghours.internal.rest.response.WorkingTimeResponse;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.pocketknife.step.StepsConverters;
import com.google.common.collect.Lists;
import io.atlassian.fugue.Either;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import org.joda.time.DateMidnight;
import org.joda.time.DateTimeZone;
import org.joda.time.LocalDate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CalendarSerialiser {
    @Autowired
    private DateTimeFormatterFactory dateTimeFormatterFactory;
    @Autowired
    private ApplicationProperties applicationProperties;
    @Autowired
    private CalendarAccessManager calendarAccessManager;

    public CalendarsResponse fromCalendarInfos(List<CalendarInfo> infos) {
        CalendarsResponse response = new CalendarsResponse();
        response.calendars = Lists.newArrayList();
        for (CalendarInfo info : infos) {
            response.calendars.add(this.fromCalendarInfo(info));
        }
        return response;
    }

    public CalendarResponse fromCalendarInfo(CalendarInfo calendar) {
        CalendarResponse response = new CalendarResponse();
        response.id = calendar.getId();
        response.name = calendar.getName();
        response.timezoneId = calendar.getTimeZone().getID();
        response.context = calendar.getContext();
        return response;
    }

    public List<CalendarResponse> fromCalendars(ApplicationUser user, List<Calendar> calendars) {
        ArrayList toReturn = Lists.newArrayList();
        for (Calendar c : calendars) {
            CalendarResponse response = this.fromCalendar(user, c);
            toReturn.add(response);
        }
        return toReturn;
    }

    public CalendarResponse fromCalendar(ApplicationUser user, Calendar calendar) {
        CalendarResponse response = this.fromCalendarInfo(calendar);
        response.holidays = this.fromHolidays(calendar.getHolidays());
        response.workingTimes = this.fromWorkingTimes(calendar.getWorkingTimes());
        response.canUpdate = this.calendarAccessManager.hasPermission(user, calendar.getContext(), Operation.UPDATE);
        response.canDelete = this.calendarAccessManager.hasPermission(user, calendar.getContext(), Operation.DELETE);
        Either validateResult = StepsConverters.newerEither(this.calendarAccessManager.validate(user, calendar, Operation.DELETE)).map(StepsConverters::newerOption);
        response.deletable = validateResult.isRight();
        response.updateMessage = this.calendarAccessManager.getOperationMessages(user, calendar, Operation.UPDATE);
        return response;
    }

    public List<WorkingTimeResponse> fromWorkingTimes(List<WorkingTime> workingTimes) {
        ArrayList list = Lists.newArrayList();
        for (WorkingTime workingTime : workingTimes) {
            list.add(this.fromWorkingTime(workingTime));
        }
        return list;
    }

    public WorkingTimeResponse fromWorkingTime(WorkingTime workingTime) {
        WorkingTimeResponse response = new WorkingTimeResponse();
        response.weekday = workingTime.getWeekday().getName();
        response.start = workingTime.getStart();
        response.end = workingTime.getEnd();
        return response;
    }

    public List<HolidayResponse> fromHolidays(List<Holiday> holidays) {
        ArrayList list = Lists.newArrayList();
        for (Holiday holiday : holidays) {
            list.add(this.fromHoliday(holiday));
        }
        return list;
    }

    public HolidayResponse fromHoliday(Holiday holiday) {
        HolidayResponse response = new HolidayResponse();
        response.name = holiday.getName();
        response.date = this.stringFromDate(holiday.getDate());
        response.recurring = holiday.isRecurring();
        return response;
    }

    public LocalDate dateFromString(String dateString) {
        DateTimeFormatter formatter = this.getFormatter();
        TimeZone zone = formatter.getZone();
        DateTimeZone dateTimeZone = DateTimeZone.forTimeZone((TimeZone)zone);
        Date parsedDate = formatter.parse(dateString);
        return new LocalDate((Object)parsedDate, dateTimeZone);
    }

    public String stringFromDate(LocalDate localDate) {
        DateTimeFormatter formatter = this.getFormatter();
        TimeZone zone = formatter.getZone();
        DateTimeZone dateTimeZone = DateTimeZone.forTimeZone((TimeZone)zone);
        DateMidnight dateMidnight = localDate.toDateMidnight(dateTimeZone);
        Date date = dateMidnight.toDate();
        return formatter.format(date);
    }

    private DateTimeFormatter getFormatter() {
        return this.dateTimeFormatterFactory.formatter().forLoggedInUser().withZone(TimeZone.getTimeZone("UTC")).withStyle(DateTimeStyle.DATE_PICKER);
    }
}

